/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.cbor;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.protocols.cbor.internal.AwsStructuredCborFactory;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.DefaultJsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.JsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.StructuredJsonFactory;

@SdkProtectedApi
public final class AwsCborProtocolFactory
extends BaseAwsJsonProtocolFactory {
    private static final JsonContentTypeResolver AWS_CBOR = new DefaultJsonContentTypeResolver("application/x-amz-cbor-");

    private AwsCborProtocolFactory(Builder builder) {
        super((BaseAwsJsonProtocolFactory.Builder)builder);
    }

    protected JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return AWS_CBOR;
        }
        return AwsJsonProtocolFactory.AWS_JSON;
    }

    protected StructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return AwsStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        return super.getSdkFactory();
    }

    private boolean isCborEnabled() {
        return SdkSystemSetting.CBOR_ENABLED.getBooleanValueOrThrow();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseAwsJsonProtocolFactory.Builder<Builder> {
        private Builder() {
        }

        public AwsCborProtocolFactory build() {
            return new AwsCborProtocolFactory(this);
        }
    }
}

