/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;

public class DescribeLaunchConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeLaunchConfigurationsRequest>, DescribeLaunchConfigurationsRequest> {
    public Request<DescribeLaunchConfigurationsRequest> marshall(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        if (describeLaunchConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeLaunchConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLaunchConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> launchConfigurationNamesList = describeLaunchConfigurationsRequest.launchConfigurationNames();
        if (launchConfigurationNamesList != null) {
            if (!launchConfigurationNamesList.isEmpty()) {
                int launchConfigurationNamesListIndex = 1;
                for (String launchConfigurationNamesListValue : launchConfigurationNamesList) {
                    if (launchConfigurationNamesListValue != null) {
                        request.addParameter("LaunchConfigurationNames.member." + launchConfigurationNamesListIndex, StringUtils.fromString((String)launchConfigurationNamesListValue));
                    }
                    ++launchConfigurationNamesListIndex;
                }
            } else {
                request.addParameter("LaunchConfigurationNames", "");
            }
        }
        if (describeLaunchConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeLaunchConfigurationsRequest.nextToken()));
        }
        if (describeLaunchConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeLaunchConfigurationsRequest.maxRecords()));
        }
        return request;
    }
}

