/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;

public final class DescribeAutoScalingGroupsPaginator
implements SdkIterable<DescribeAutoScalingGroupsResponse> {
    private final AutoScalingClient client;
    private final DescribeAutoScalingGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeAutoScalingGroupsPaginator(AutoScalingClient client, DescribeAutoScalingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAutoScalingGroupsResponseFetcher();
    }

    public Iterator<DescribeAutoScalingGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AutoScalingGroup> autoScalingGroups() {
        Function<DescribeAutoScalingGroupsResponse, Iterator> getIterator = response -> response != null ? response.autoScalingGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeAutoScalingGroupsResponseFetcher
    implements NextPageFetcher<DescribeAutoScalingGroupsResponse> {
        private DescribeAutoScalingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingGroupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAutoScalingGroupsResponse nextPage(DescribeAutoScalingGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingGroupsPaginator.this.client.describeAutoScalingGroups(DescribeAutoScalingGroupsPaginator.this.firstRequest);
            }
            return DescribeAutoScalingGroupsPaginator.this.client.describeAutoScalingGroups((DescribeAutoScalingGroupsRequest)((Object)DescribeAutoScalingGroupsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

