/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingNotificationTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutNotificationConfigurationRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, PutNotificationConfigurationRequest> {
    private final String autoScalingGroupName;
    private final String topicARN;
    private final List<String> notificationTypes;

    private PutNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationTypes = builder.notificationTypes;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String topicARN() {
        return this.topicARN;
    }

    public List<String> notificationTypes() {
        return this.notificationTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutNotificationConfigurationRequest)) {
            return false;
        }
        PutNotificationConfigurationRequest other = (PutNotificationConfigurationRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.topicARN(), other.topicARN()) && Objects.equals(this.notificationTypes(), other.notificationTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.topicARN() != null) {
            sb.append("TopicARN: ").append(this.topicARN()).append(",");
        }
        if (this.notificationTypes() != null) {
            sb.append("NotificationTypes: ").append(this.notificationTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "TopicARN": {
                return Optional.of(clazz.cast(this.topicARN()));
            }
            case "NotificationTypes": {
                return Optional.of(clazz.cast(this.notificationTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String topicARN;
        private List<String> notificationTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(PutNotificationConfigurationRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.topicARN(model.topicARN);
            this.notificationTypes(model.notificationTypes);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return this.topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final Collection<String> getNotificationTypes() {
            return this.notificationTypes;
        }

        @Override
        public final Builder notificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTypes(String ... notificationTypes) {
            this.notificationTypes(Arrays.asList(notificationTypes));
            return this;
        }

        public final void setNotificationTypes(Collection<String> notificationTypes) {
            this.notificationTypes = AutoScalingNotificationTypesCopier.copy(notificationTypes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutNotificationConfigurationRequest build() {
            return new PutNotificationConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, PutNotificationConfigurationRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder topicARN(String var1);

        public Builder notificationTypes(Collection<String> var1);

        public Builder notificationTypes(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

