/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.ProcessType;
import software.amazon.awssdk.services.autoscaling.model.ProcessesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalingProcessTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
    private final List<ProcessType> processes;

    private DescribeScalingProcessTypesResponse(BuilderImpl builder) {
        super(builder);
        this.processes = builder.processes;
    }

    public List<ProcessType> processes() {
        return this.processes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.processes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingProcessTypesResponse)) {
            return false;
        }
        DescribeScalingProcessTypesResponse other = (DescribeScalingProcessTypesResponse)((Object)obj);
        return Objects.equals(this.processes(), other.processes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.processes() != null) {
            sb.append("Processes: ").append(this.processes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Processes": {
                return Optional.of(clazz.cast(this.processes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ProcessType> processes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingProcessTypesResponse model) {
            this.processes(model.processes);
        }

        public final Collection<ProcessType.Builder> getProcesses() {
            return this.processes != null ? (Collection)this.processes.stream().map(ProcessType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processes(Collection<ProcessType> processes) {
            this.processes = ProcessesCopier.copy(processes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processes(ProcessType ... processes) {
            this.processes(Arrays.asList(processes));
            return this;
        }

        public final void setProcesses(Collection<ProcessType.BuilderImpl> processes) {
            this.processes = ProcessesCopier.copyFromBuilder(processes);
        }

        @Override
        public DescribeScalingProcessTypesResponse build() {
            return new DescribeScalingProcessTypesResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, DescribeScalingProcessTypesResponse> {
        public Builder processes(Collection<ProcessType> var1);

        public Builder processes(ProcessType ... var1);
    }
}

