/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerTargetGroupState;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerTargetGroupStatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerTargetGroupsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
    private final List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;
    private final String nextToken;

    private DescribeLoadBalancerTargetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.nextToken = builder.nextToken;
    }

    public List<LoadBalancerTargetGroupState> loadBalancerTargetGroups() {
        return this.loadBalancerTargetGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerTargetGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerTargetGroupsResponse)) {
            return false;
        }
        DescribeLoadBalancerTargetGroupsResponse other = (DescribeLoadBalancerTargetGroupsResponse)((Object)obj);
        return Objects.equals(this.loadBalancerTargetGroups(), other.loadBalancerTargetGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerTargetGroups() != null) {
            sb.append("LoadBalancerTargetGroups: ").append(this.loadBalancerTargetGroups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerTargetGroups": {
                return Optional.of(clazz.cast(this.loadBalancerTargetGroups()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerTargetGroupsResponse model) {
            this.loadBalancerTargetGroups(model.loadBalancerTargetGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<LoadBalancerTargetGroupState.Builder> getLoadBalancerTargetGroups() {
            return this.loadBalancerTargetGroups != null ? (Collection)this.loadBalancerTargetGroups.stream().map(LoadBalancerTargetGroupState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        public final void setLoadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState.BuilderImpl> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copyFromBuilder(loadBalancerTargetGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLoadBalancerTargetGroupsResponse build() {
            return new DescribeLoadBalancerTargetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    CopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
        public Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> var1);

        public Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState ... var1);

        public Builder nextToken(String var1);
    }
}

