/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;

public class PutNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {
    public Request<PutNotificationConfigurationRequest> marshall(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        List<String> notificationTypesList;
        if (putNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putNotificationConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putNotificationConfigurationRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putNotificationConfigurationRequest.autoScalingGroupName()));
        }
        if (putNotificationConfigurationRequest.topicARN() != null) {
            request.addParameter("TopicARN", StringUtils.fromString((String)putNotificationConfigurationRequest.topicARN()));
        }
        if ((notificationTypesList = putNotificationConfigurationRequest.notificationTypes()) != null) {
            if (!notificationTypesList.isEmpty()) {
                int notificationTypesListIndex = 1;
                for (String notificationTypesListValue : notificationTypesList) {
                    if (notificationTypesListValue != null) {
                        request.addParameter("NotificationTypes.member." + notificationTypesListIndex, StringUtils.fromString((String)notificationTypesListValue));
                    }
                    ++notificationTypesListIndex;
                }
            } else {
                request.addParameter("NotificationTypes", "");
            }
        }
        return request;
    }
}

