/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;
import software.amazon.awssdk.services.autoscaling.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.InstanceMonitoringUnmarshaller;

public class LaunchConfigurationUnmarshaller
implements Unmarshaller<LaunchConfiguration, StaxUnmarshallerContext> {
    private static final LaunchConfigurationUnmarshaller INSTANCE = new LaunchConfigurationUnmarshaller();

    public LaunchConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchConfiguration.Builder launchConfiguration;
        block25: {
            launchConfiguration = LaunchConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> securityGroups = null;
            ArrayList<String> classicLinkVPCSecurityGroups = null;
            ArrayList<BlockDeviceMapping> blockDeviceMappings = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    launchConfiguration.securityGroups(securityGroups);
                    launchConfiguration.classicLinkVPCSecurityGroups(classicLinkVPCSecurityGroups);
                    launchConfiguration.blockDeviceMappings(blockDeviceMappings);
                    break block25;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                        launchConfiguration.launchConfigurationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LaunchConfigurationARN", targetDepth)) {
                        launchConfiguration.launchConfigurationARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ImageId", targetDepth)) {
                        launchConfiguration.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KeyName", targetDepth)) {
                        launchConfiguration.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SecurityGroups", targetDepth)) {
                        securityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SecurityGroups/member", targetDepth)) {
                        securityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClassicLinkVPCId", targetDepth)) {
                        launchConfiguration.classicLinkVPCId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClassicLinkVPCSecurityGroups", targetDepth)) {
                        classicLinkVPCSecurityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("ClassicLinkVPCSecurityGroups/member", targetDepth)) {
                        classicLinkVPCSecurityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserData", targetDepth)) {
                        launchConfiguration.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceType", targetDepth)) {
                        launchConfiguration.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KernelId", targetDepth)) {
                        launchConfiguration.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RamdiskId", targetDepth)) {
                        launchConfiguration.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BlockDeviceMappings", targetDepth)) {
                        blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("BlockDeviceMappings/member", targetDepth)) {
                        blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceMonitoring", targetDepth)) {
                        launchConfiguration.instanceMonitoring(InstanceMonitoringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SpotPrice", targetDepth)) {
                        launchConfiguration.spotPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IamInstanceProfile", targetDepth)) {
                        launchConfiguration.iamInstanceProfile(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreatedTime", targetDepth)) {
                        launchConfiguration.createdTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EbsOptimized", targetDepth)) {
                        launchConfiguration.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AssociatePublicIpAddress", targetDepth)) {
                        launchConfiguration.associatePublicIpAddress(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("PlacementTenancy", targetDepth)) continue;
                    launchConfiguration.placementTenancy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            launchConfiguration.securityGroups(securityGroups);
            launchConfiguration.classicLinkVPCSecurityGroups(classicLinkVPCSecurityGroups);
            launchConfiguration.blockDeviceMappings(blockDeviceMappings);
        }
        return (LaunchConfiguration)launchConfiguration.build();
    }

    public static LaunchConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

