/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;

public class DescribeLifecycleHooksRequestMarshaller
implements Marshaller<Request<DescribeLifecycleHooksRequest>, DescribeLifecycleHooksRequest> {
    public Request<DescribeLifecycleHooksRequest> marshall(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        List<String> lifecycleHookNamesList;
        if (describeLifecycleHooksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLifecycleHooksRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLifecycleHooks");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLifecycleHooksRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)describeLifecycleHooksRequest.autoScalingGroupName()));
        }
        if ((lifecycleHookNamesList = describeLifecycleHooksRequest.lifecycleHookNames()) != null) {
            if (!lifecycleHookNamesList.isEmpty()) {
                int lifecycleHookNamesListIndex = 1;
                for (String lifecycleHookNamesListValue : lifecycleHookNamesList) {
                    if (lifecycleHookNamesListValue != null) {
                        request.addParameter("LifecycleHookNames.member." + lifecycleHookNamesListIndex, StringUtils.fromString((String)lifecycleHookNamesListValue));
                    }
                    ++lifecycleHookNamesListIndex;
                }
            } else {
                request.addParameter("LifecycleHookNames", "");
            }
        }
        return request;
    }
}

