/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.Activity;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;

public final class DescribeScalingActivitiesPaginator
implements SdkIterable<DescribeScalingActivitiesResponse> {
    private final AutoScalingClient client;
    private final DescribeScalingActivitiesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeScalingActivitiesPaginator(AutoScalingClient client, DescribeScalingActivitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScalingActivitiesResponseFetcher();
    }

    public Iterator<DescribeScalingActivitiesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Activity> activities() {
        Function<DescribeScalingActivitiesResponse, Iterator> getIterator = response -> response != null ? response.activities().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeScalingActivitiesResponseFetcher
    implements NextPageFetcher<DescribeScalingActivitiesResponse> {
        private DescribeScalingActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalingActivitiesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeScalingActivitiesResponse nextPage(DescribeScalingActivitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalingActivitiesPaginator.this.client.describeScalingActivities(DescribeScalingActivitiesPaginator.this.firstRequest);
            }
            return DescribeScalingActivitiesPaginator.this.client.describeScalingActivities((DescribeScalingActivitiesRequest)((Object)DescribeScalingActivitiesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

