/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;

public final class DescribeLaunchConfigurationsPaginator
implements SdkIterable<DescribeLaunchConfigurationsResponse> {
    private final AutoScalingClient client;
    private final DescribeLaunchConfigurationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeLaunchConfigurationsPaginator(AutoScalingClient client, DescribeLaunchConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLaunchConfigurationsResponseFetcher();
    }

    public Iterator<DescribeLaunchConfigurationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<LaunchConfiguration> launchConfigurations() {
        Function<DescribeLaunchConfigurationsResponse, Iterator> getIterator = response -> response != null ? response.launchConfigurations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeLaunchConfigurationsResponseFetcher
    implements NextPageFetcher<DescribeLaunchConfigurationsResponse> {
        private DescribeLaunchConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchConfigurationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeLaunchConfigurationsResponse nextPage(DescribeLaunchConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchConfigurationsPaginator.this.client.describeLaunchConfigurations(DescribeLaunchConfigurationsPaginator.this.firstRequest);
            }
            return DescribeLaunchConfigurationsPaginator.this.client.describeLaunchConfigurations((DescribeLaunchConfigurationsRequest)((Object)DescribeLaunchConfigurationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

