/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.InstanceIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetInstanceProtectionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetInstanceProtectionRequest> {
    private final List<String> instanceIds;
    private final String autoScalingGroupName;
    private final Boolean protectedFromScaleIn;

    private SetInstanceProtectionRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Boolean protectedFromScaleIn() {
        return this.protectedFromScaleIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedFromScaleIn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetInstanceProtectionRequest)) {
            return false;
        }
        SetInstanceProtectionRequest other = (SetInstanceProtectionRequest)((Object)obj);
        return Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.protectedFromScaleIn(), other.protectedFromScaleIn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.protectedFromScaleIn() != null) {
            sb.append("ProtectedFromScaleIn: ").append(this.protectedFromScaleIn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceIds": {
                return Optional.of(clazz.cast(this.instanceIds()));
            }
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "ProtectedFromScaleIn": {
                return Optional.of(clazz.cast(this.protectedFromScaleIn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds;
        private String autoScalingGroupName;
        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(SetInstanceProtectionRequest model) {
            this.instanceIds(model.instanceIds);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.protectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getProtectedFromScaleIn() {
            return this.protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        public SetInstanceProtectionRequest build() {
            return new SetInstanceProtectionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetInstanceProtectionRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder autoScalingGroupName(String var1);

        public Builder protectedFromScaleIn(Boolean var1);
    }
}

