/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.Alarm;
import software.amazon.awssdk.services.autoscaling.model.AlarmsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutScalingPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutScalingPolicyResponse> {
    private final String policyARN;
    private final List<Alarm> alarms;

    private PutScalingPolicyResponse(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
        this.alarms = builder.alarms;
    }

    public String policyARN() {
        return this.policyARN;
    }

    public List<Alarm> alarms() {
        return this.alarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResponse)) {
            return false;
        }
        PutScalingPolicyResponse other = (PutScalingPolicyResponse)((Object)obj);
        return Objects.equals(this.policyARN(), other.policyARN()) && Objects.equals(this.alarms(), other.alarms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyARN() != null) {
            sb.append("PolicyARN: ").append(this.policyARN()).append(",");
        }
        if (this.alarms() != null) {
            sb.append("Alarms: ").append(this.alarms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyARN": {
                return Optional.of(clazz.cast(this.policyARN()));
            }
            case "Alarms": {
                return Optional.of(clazz.cast(this.alarms()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyARN;
        private List<Alarm> alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyResponse model) {
            this.policyARN(model.policyARN);
            this.alarms(model.alarms);
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final Collection<Alarm.Builder> getAlarms() {
            return this.alarms != null ? (Collection)this.alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        public PutScalingPolicyResponse build() {
            return new PutScalingPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutScalingPolicyResponse> {
        public Builder policyARN(String var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);
    }
}

