/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachLoadBalancerTargetGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachLoadBalancerTargetGroupsRequest> {
    private final String autoScalingGroupName;
    private final List<String> targetGroupARNs;

    private AttachLoadBalancerTargetGroupsRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.targetGroupARNs = builder.targetGroupARNs;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupARNs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachLoadBalancerTargetGroupsRequest)) {
            return false;
        }
        AttachLoadBalancerTargetGroupsRequest other = (AttachLoadBalancerTargetGroupsRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.targetGroupARNs() != null) {
            sb.append("TargetGroupARNs: ").append(this.targetGroupARNs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "TargetGroupARNs": {
                return Optional.of(clazz.cast(this.targetGroupARNs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> targetGroupARNs;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachLoadBalancerTargetGroupsRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.targetGroupARNs(model.targetGroupARNs);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getTargetGroupARNs() {
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        public AttachLoadBalancerTargetGroupsRequest build() {
            return new AttachLoadBalancerTargetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachLoadBalancerTargetGroupsRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);
    }
}

