/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer.internal;

import java.time.Clock;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerUtils;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.regions.Region;

@SdkProtectedApi
public final class Aws4SignerRequestParams {
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceSigningName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;

    public Aws4SignerRequestParams(Aws4SignerParams signerParams) {
        this.signingDateTimeMilli = this.getSigningDate(signerParams);
        this.formattedSigningDate = Aws4SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceSigningName = signerParams.signingName();
        this.regionName = this.getRegion(signerParams.signingRegion());
        this.scope = this.generateScope(this.formattedSigningDate, this.serviceSigningName, this.regionName);
        this.formattedSigningDateTime = Aws4SignerUtils.formatTimestamp(this.signingDateTimeMilli);
    }

    private long getSigningDate(Aws4SignerParams signerParams) {
        return signerParams.signingClockOverride().map(Clock::millis).orElse(signerParams.timeOffset().map(t -> System.currentTimeMillis() - (long)t.intValue() * 1000L).orElse(System.currentTimeMillis()));
    }

    private String getRegion(Region region) {
        return region != null ? region.id() : null;
    }

    private String generateScope(String dateStamp, String serviceName, String regionName) {
        return dateStamp + "/" + regionName + "/" + serviceName + "/" + "aws4_request";
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceSigningName() {
        return this.serviceSigningName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return "AWS4-HMAC-SHA256";
    }
}

