/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FrameworkType {
    STANDARD("Standard"),
    CUSTOM("Custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FrameworkType> VALUE_MAP;
    private final String value;

    private FrameworkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FrameworkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FrameworkType> knownValues() {
        EnumSet<FrameworkType> knownValues = EnumSet.allOf(FrameworkType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FrameworkType.class, FrameworkType::toString);
    }
}

