/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.EvidenceFinderBackfillStatus;
import software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablementStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvidenceFinderEnablement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvidenceFinderEnablement> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventDataStoreArn").getter(EvidenceFinderEnablement.getter(EvidenceFinderEnablement::eventDataStoreArn)).setter(EvidenceFinderEnablement.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDataStoreArn").build()}).build();
    private static final SdkField<String> ENABLEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enablementStatus").getter(EvidenceFinderEnablement.getter(EvidenceFinderEnablement::enablementStatusAsString)).setter(EvidenceFinderEnablement.setter(Builder::enablementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablementStatus").build()}).build();
    private static final SdkField<String> BACKFILL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backfillStatus").getter(EvidenceFinderEnablement.getter(EvidenceFinderEnablement::backfillStatusAsString)).setter(EvidenceFinderEnablement.setter(Builder::backfillStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backfillStatus").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(EvidenceFinderEnablement.getter(EvidenceFinderEnablement::error)).setter(EvidenceFinderEnablement.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD, ENABLEMENT_STATUS_FIELD, BACKFILL_STATUS_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvidenceFinderEnablement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventDataStoreArn;
    private final String enablementStatus;
    private final String backfillStatus;
    private final String error;

    private EvidenceFinderEnablement(BuilderImpl builder) {
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.enablementStatus = builder.enablementStatus;
        this.backfillStatus = builder.backfillStatus;
        this.error = builder.error;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final EvidenceFinderEnablementStatus enablementStatus() {
        return EvidenceFinderEnablementStatus.fromValue(this.enablementStatus);
    }

    public final String enablementStatusAsString() {
        return this.enablementStatus;
    }

    public final EvidenceFinderBackfillStatus backfillStatus() {
        return EvidenceFinderBackfillStatus.fromValue(this.backfillStatus);
    }

    public final String backfillStatusAsString() {
        return this.backfillStatus;
    }

    public final String error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backfillStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvidenceFinderEnablement)) {
            return false;
        }
        EvidenceFinderEnablement other = (EvidenceFinderEnablement)obj;
        return Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.enablementStatusAsString(), other.enablementStatusAsString()) && Objects.equals(this.backfillStatusAsString(), other.backfillStatusAsString()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"EvidenceFinderEnablement").add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("EnablementStatus", (Object)this.enablementStatusAsString()).add("BackfillStatus", (Object)this.backfillStatusAsString()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "enablementStatus": {
                return Optional.ofNullable(clazz.cast(this.enablementStatusAsString()));
            }
            case "backfillStatus": {
                return Optional.ofNullable(clazz.cast(this.backfillStatusAsString()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("eventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
        map.put("enablementStatus", ENABLEMENT_STATUS_FIELD);
        map.put("backfillStatus", BACKFILL_STATUS_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvidenceFinderEnablement, T> g) {
        return obj -> g.apply((EvidenceFinderEnablement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventDataStoreArn;
        private String enablementStatus;
        private String backfillStatus;
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(EvidenceFinderEnablement model) {
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.enablementStatus(model.enablementStatus);
            this.backfillStatus(model.backfillStatus);
            this.error(model.error);
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getEnablementStatus() {
            return this.enablementStatus;
        }

        public final void setEnablementStatus(String enablementStatus) {
            this.enablementStatus = enablementStatus;
        }

        @Override
        public final Builder enablementStatus(String enablementStatus) {
            this.enablementStatus = enablementStatus;
            return this;
        }

        @Override
        public final Builder enablementStatus(EvidenceFinderEnablementStatus enablementStatus) {
            this.enablementStatus(enablementStatus == null ? null : enablementStatus.toString());
            return this;
        }

        public final String getBackfillStatus() {
            return this.backfillStatus;
        }

        public final void setBackfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
        }

        @Override
        public final Builder backfillStatus(String backfillStatus) {
            this.backfillStatus = backfillStatus;
            return this;
        }

        @Override
        public final Builder backfillStatus(EvidenceFinderBackfillStatus backfillStatus) {
            this.backfillStatus(backfillStatus == null ? null : backfillStatus.toString());
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public EvidenceFinderEnablement build() {
            return new EvidenceFinderEnablement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvidenceFinderEnablement> {
        public Builder eventDataStoreArn(String var1);

        public Builder enablementStatus(String var1);

        public Builder enablementStatus(EvidenceFinderEnablementStatus var1);

        public Builder backfillStatus(String var1);

        public Builder backfillStatus(EvidenceFinderBackfillStatus var1);

        public Builder error(String var1);
    }
}

