/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl;
import software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssessmentFrameworkControlSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateAssessmentFrameworkControlSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAssessmentFrameworkControlSet.getter(CreateAssessmentFrameworkControlSet::name)).setter(CreateAssessmentFrameworkControlSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<CreateAssessmentFrameworkControl>> CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controls").getter(CreateAssessmentFrameworkControlSet.getter(CreateAssessmentFrameworkControlSet::controls)).setter(CreateAssessmentFrameworkControlSet.setter(Builder::controls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateAssessmentFrameworkControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTROLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAssessmentFrameworkControlSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<CreateAssessmentFrameworkControl> controls;

    private CreateAssessmentFrameworkControlSet(BuilderImpl builder) {
        this.name = builder.name;
        this.controls = builder.controls;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasControls() {
        return this.controls != null && !(this.controls instanceof SdkAutoConstructList);
    }

    public final List<CreateAssessmentFrameworkControl> controls() {
        return this.controls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControls() ? this.controls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentFrameworkControlSet)) {
            return false;
        }
        CreateAssessmentFrameworkControlSet other = (CreateAssessmentFrameworkControlSet)obj;
        return Objects.equals(this.name(), other.name()) && this.hasControls() == other.hasControls() && Objects.equals(this.controls(), other.controls());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssessmentFrameworkControlSet").add("Name", (Object)this.name()).add("Controls", this.hasControls() ? this.controls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "controls": {
                return Optional.ofNullable(clazz.cast(this.controls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("controls", CONTROLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentFrameworkControlSet, T> g) {
        return obj -> g.apply((CreateAssessmentFrameworkControlSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<CreateAssessmentFrameworkControl> controls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentFrameworkControlSet model) {
            this.name(model.name);
            this.controls(model.controls);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<CreateAssessmentFrameworkControl.Builder> getControls() {
            List<CreateAssessmentFrameworkControl.Builder> result = CreateAssessmentFrameworkControlsCopier.copyToBuilder(this.controls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControls(Collection<CreateAssessmentFrameworkControl.BuilderImpl> controls) {
            this.controls = CreateAssessmentFrameworkControlsCopier.copyFromBuilder(controls);
        }

        @Override
        public final Builder controls(Collection<CreateAssessmentFrameworkControl> controls) {
            this.controls = CreateAssessmentFrameworkControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(CreateAssessmentFrameworkControl ... controls) {
            this.controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<CreateAssessmentFrameworkControl.Builder> ... controls) {
            this.controls(Stream.of(controls).map(c -> (CreateAssessmentFrameworkControl)((CreateAssessmentFrameworkControl.Builder)CreateAssessmentFrameworkControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateAssessmentFrameworkControlSet build() {
            return new CreateAssessmentFrameworkControlSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateAssessmentFrameworkControlSet> {
        public Builder name(String var1);

        public Builder controls(Collection<CreateAssessmentFrameworkControl> var1);

        public Builder controls(CreateAssessmentFrameworkControl ... var1);

        public Builder controls(Consumer<CreateAssessmentFrameworkControl.Builder> ... var1);
    }
}

