/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest;
import software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse;

public class GetEvidenceFoldersByAssessmentIterable
implements SdkIterable<GetEvidenceFoldersByAssessmentResponse> {
    private final AuditManagerClient client;
    private final GetEvidenceFoldersByAssessmentRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEvidenceFoldersByAssessmentIterable(AuditManagerClient client, GetEvidenceFoldersByAssessmentRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetEvidenceFoldersByAssessmentResponseFetcher();
    }

    public Iterator<GetEvidenceFoldersByAssessmentResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetEvidenceFoldersByAssessmentResponseFetcher
    implements SyncPageFetcher<GetEvidenceFoldersByAssessmentResponse> {
        private GetEvidenceFoldersByAssessmentResponseFetcher() {
        }

        public boolean hasNextPage(GetEvidenceFoldersByAssessmentResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEvidenceFoldersByAssessmentResponse nextPage(GetEvidenceFoldersByAssessmentResponse previousPage) {
            if (previousPage == null) {
                return GetEvidenceFoldersByAssessmentIterable.this.client.getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentIterable.this.firstRequest);
            }
            return GetEvidenceFoldersByAssessmentIterable.this.client.getEvidenceFoldersByAssessment((GetEvidenceFoldersByAssessmentRequest)((Object)GetEvidenceFoldersByAssessmentIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

