/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionEnum {
    CREATE("CREATE"),
    UPDATE_METADATA("UPDATE_METADATA"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    DELETE("DELETE"),
    UNDER_REVIEW("UNDER_REVIEW"),
    REVIEWED("REVIEWED"),
    IMPORT_EVIDENCE("IMPORT_EVIDENCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionEnum> VALUE_MAP;
    private final String value;

    private ActionEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionEnum> knownValues() {
        EnumSet<ActionEnum> knownValues = EnumSet.allOf(ActionEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionEnum.class, ActionEnum::toString);
    }
}

