/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEvidenceFileUploadUrlRequest extends AuditManagerRequest implements
        ToCopyableBuilder<GetEvidenceFileUploadUrlRequest.Builder, GetEvidenceFileUploadUrlRequest> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(GetEvidenceFileUploadUrlRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD));

    private final String fileName;

    private GetEvidenceFileUploadUrlRequest(BuilderImpl builder) {
        super(builder);
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The file that you want to upload. For a list of supported file formats, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>.
     * </p>
     * 
     * @return The file that you want to upload. For a list of supported file formats, see <a href=
     *         "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
     *         >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>.
     */
    public final String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvidenceFileUploadUrlRequest)) {
            return false;
        }
        GetEvidenceFileUploadUrlRequest other = (GetEvidenceFileUploadUrlRequest) obj;
        return Objects.equals(fileName(), other.fileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEvidenceFileUploadUrlRequest").add("FileName", fileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEvidenceFileUploadUrlRequest, T> g) {
        return obj -> g.apply((GetEvidenceFileUploadUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEvidenceFileUploadUrlRequest> {
        /**
         * <p>
         * The file that you want to upload. For a list of supported file formats, see <a href=
         * "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
         * >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>.
         * </p>
         * 
         * @param fileName
         *        The file that you want to upload. For a list of supported file formats, see <a href=
         *        "https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files"
         *        >Supported file types for manual evidence</a> in the <i>Audit Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvidenceFileUploadUrlRequest model) {
            super(model);
            fileName(model.fileName);
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEvidenceFileUploadUrlRequest build() {
            return new GetEvidenceFileUploadUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
