/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata of a framework, such as the name, ID, or description.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameworkMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameworkMetadata.Builder, FrameworkMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FrameworkMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(FrameworkMetadata::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> LOGO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logo")
            .getter(getter(FrameworkMetadata::logo)).setter(setter(Builder::logo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logo").build()).build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(FrameworkMetadata::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            LOGO_FIELD, COMPLIANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String logo;

    private final String complianceType;

    private FrameworkMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.logo = builder.logo;
        this.complianceType = builder.complianceType;
    }

    /**
     * <p>
     * The name of the framework.
     * </p>
     * 
     * @return The name of the framework.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the framework.
     * </p>
     * 
     * @return The description of the framework.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The logo that's associated with the framework.
     * </p>
     * 
     * @return The logo that's associated with the framework.
     */
    public final String logo() {
        return logo;
    }

    /**
     * <p>
     * The compliance standard that's associated with the framework. For example, this could be PCI DSS or HIPAA.
     * </p>
     * 
     * @return The compliance standard that's associated with the framework. For example, this could be PCI DSS or
     *         HIPAA.
     */
    public final String complianceType() {
        return complianceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(logo());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameworkMetadata)) {
            return false;
        }
        FrameworkMetadata other = (FrameworkMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(logo(), other.logo()) && Objects.equals(complianceType(), other.complianceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrameworkMetadata").add("Name", name()).add("Description", description()).add("Logo", logo())
                .add("ComplianceType", complianceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "logo":
            return Optional.ofNullable(clazz.cast(logo()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameworkMetadata, T> g) {
        return obj -> g.apply((FrameworkMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameworkMetadata> {
        /**
         * <p>
         * The name of the framework.
         * </p>
         * 
         * @param name
         *        The name of the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the framework.
         * </p>
         * 
         * @param description
         *        The description of the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The logo that's associated with the framework.
         * </p>
         * 
         * @param logo
         *        The logo that's associated with the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo(String logo);

        /**
         * <p>
         * The compliance standard that's associated with the framework. For example, this could be PCI DSS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance standard that's associated with the framework. For example, this could be PCI DSS or
         *        HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String logo;

        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameworkMetadata model) {
            name(model.name);
            description(model.description);
            logo(model.logo);
            complianceType(model.complianceType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLogo() {
            return logo;
        }

        public final void setLogo(String logo) {
            this.logo = logo;
        }

        @Override
        public final Builder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public FrameworkMetadata build() {
            return new FrameworkMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
