/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateDelegationByAssessmentRequest extends AuditManagerRequest implements
        ToCopyableBuilder<BatchCreateDelegationByAssessmentRequest.Builder, BatchCreateDelegationByAssessmentRequest> {
    private static final SdkField<List<CreateDelegationRequest>> CREATE_DELEGATION_REQUESTS_FIELD = SdkField
            .<List<CreateDelegationRequest>> builder(MarshallingType.LIST)
            .memberName("createDelegationRequests")
            .getter(getter(BatchCreateDelegationByAssessmentRequest::createDelegationRequests))
            .setter(setter(Builder::createDelegationRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDelegationRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateDelegationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateDelegationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(BatchCreateDelegationByAssessmentRequest::assessmentId))
            .setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CREATE_DELEGATION_REQUESTS_FIELD, ASSESSMENT_ID_FIELD));

    private final List<CreateDelegationRequest> createDelegationRequests;

    private final String assessmentId;

    private BatchCreateDelegationByAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.createDelegationRequests = builder.createDelegationRequests;
        this.assessmentId = builder.assessmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateDelegationRequests property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateDelegationRequests() {
        return createDelegationRequests != null && !(createDelegationRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The API request to batch create delegations in Audit Manager.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateDelegationRequests} method.
     * </p>
     * 
     * @return The API request to batch create delegations in Audit Manager.
     */
    public final List<CreateDelegationRequest> createDelegationRequests() {
        return createDelegationRequests;
    }

    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     * 
     * @return The identifier for the assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateDelegationRequests() ? createDelegationRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateDelegationByAssessmentRequest)) {
            return false;
        }
        BatchCreateDelegationByAssessmentRequest other = (BatchCreateDelegationByAssessmentRequest) obj;
        return hasCreateDelegationRequests() == other.hasCreateDelegationRequests()
                && Objects.equals(createDelegationRequests(), other.createDelegationRequests())
                && Objects.equals(assessmentId(), other.assessmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateDelegationByAssessmentRequest")
                .add("CreateDelegationRequests", hasCreateDelegationRequests() ? createDelegationRequests() : null)
                .add("AssessmentId", assessmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createDelegationRequests":
            return Optional.ofNullable(clazz.cast(createDelegationRequests()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateDelegationByAssessmentRequest, T> g) {
        return obj -> g.apply((BatchCreateDelegationByAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateDelegationByAssessmentRequest> {
        /**
         * <p>
         * The API request to batch create delegations in Audit Manager.
         * </p>
         * 
         * @param createDelegationRequests
         *        The API request to batch create delegations in Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDelegationRequests(Collection<CreateDelegationRequest> createDelegationRequests);

        /**
         * <p>
         * The API request to batch create delegations in Audit Manager.
         * </p>
         * 
         * @param createDelegationRequests
         *        The API request to batch create delegations in Audit Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDelegationRequests(CreateDelegationRequest... createDelegationRequests);

        /**
         * <p>
         * The API request to batch create delegations in Audit Manager.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #createDelegationRequests(List<CreateDelegationRequest>)}.
         * 
         * @param createDelegationRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createDelegationRequests(java.util.Collection<CreateDelegationRequest>)
         */
        Builder createDelegationRequests(Consumer<CreateDelegationRequest.Builder>... createDelegationRequests);

        /**
         * <p>
         * The identifier for the assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private List<CreateDelegationRequest> createDelegationRequests = DefaultSdkAutoConstructList.getInstance();

        private String assessmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateDelegationByAssessmentRequest model) {
            super(model);
            createDelegationRequests(model.createDelegationRequests);
            assessmentId(model.assessmentId);
        }

        public final List<CreateDelegationRequest.Builder> getCreateDelegationRequests() {
            List<CreateDelegationRequest.Builder> result = CreateDelegationRequestsCopier
                    .copyToBuilder(this.createDelegationRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateDelegationRequests(Collection<CreateDelegationRequest.BuilderImpl> createDelegationRequests) {
            this.createDelegationRequests = CreateDelegationRequestsCopier.copyFromBuilder(createDelegationRequests);
        }

        @Override
        public final Builder createDelegationRequests(Collection<CreateDelegationRequest> createDelegationRequests) {
            this.createDelegationRequests = CreateDelegationRequestsCopier.copy(createDelegationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDelegationRequests(CreateDelegationRequest... createDelegationRequests) {
            createDelegationRequests(Arrays.asList(createDelegationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDelegationRequests(Consumer<CreateDelegationRequest.Builder>... createDelegationRequests) {
            createDelegationRequests(Stream.of(createDelegationRequests)
                    .map(c -> CreateDelegationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateDelegationByAssessmentRequest build() {
            return new BatchCreateDelegationByAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
