/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse;

public class GetDelegationsIterable
implements SdkIterable<GetDelegationsResponse> {
    private final AuditManagerClient client;
    private final GetDelegationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDelegationsIterable(AuditManagerClient client, GetDelegationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDelegationsResponseFetcher();
    }

    public Iterator<GetDelegationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDelegationsResponseFetcher
    implements SyncPageFetcher<GetDelegationsResponse> {
        private GetDelegationsResponseFetcher() {
        }

        public boolean hasNextPage(GetDelegationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDelegationsResponse nextPage(GetDelegationsResponse previousPage) {
            if (previousPage == null) {
                return GetDelegationsIterable.this.client.getDelegations(GetDelegationsIterable.this.firstRequest);
            }
            return GetDelegationsIterable.this.client.getDelegations((GetDelegationsRequest)((Object)GetDelegationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

