/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSettingsRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, UpdateSettingsRequest> {
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopic").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::snsTopic)).setter(UpdateSettingsRequest.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()}).build();
    private static final SdkField<AssessmentReportsDestination> DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultAssessmentReportsDestination").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::defaultAssessmentReportsDestination)).setter(UpdateSettingsRequest.setter(Builder::defaultAssessmentReportsDestination)).constructor(AssessmentReportsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAssessmentReportsDestination").build()}).build();
    private static final SdkField<List<Role>> DEFAULT_PROCESS_OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultProcessOwners").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::defaultProcessOwners)).setter(UpdateSettingsRequest.setter(Builder::defaultProcessOwners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultProcessOwners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKey").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::kmsKey)).setter(UpdateSettingsRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final SdkField<Boolean> EVIDENCE_FINDER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("evidenceFinderEnabled").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::evidenceFinderEnabled)).setter(UpdateSettingsRequest.setter(Builder::evidenceFinderEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidenceFinderEnabled").build()}).build();
    private static final SdkField<DeregistrationPolicy> DEREGISTRATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deregistrationPolicy").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::deregistrationPolicy)).setter(UpdateSettingsRequest.setter(Builder::deregistrationPolicy)).constructor(DeregistrationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deregistrationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_FIELD, DEFAULT_ASSESSMENT_REPORTS_DESTINATION_FIELD, DEFAULT_PROCESS_OWNERS_FIELD, KMS_KEY_FIELD, EVIDENCE_FINDER_ENABLED_FIELD, DEREGISTRATION_POLICY_FIELD));
    private final String snsTopic;
    private final AssessmentReportsDestination defaultAssessmentReportsDestination;
    private final List<Role> defaultProcessOwners;
    private final String kmsKey;
    private final Boolean evidenceFinderEnabled;
    private final DeregistrationPolicy deregistrationPolicy;

    private UpdateSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.snsTopic = builder.snsTopic;
        this.defaultAssessmentReportsDestination = builder.defaultAssessmentReportsDestination;
        this.defaultProcessOwners = builder.defaultProcessOwners;
        this.kmsKey = builder.kmsKey;
        this.evidenceFinderEnabled = builder.evidenceFinderEnabled;
        this.deregistrationPolicy = builder.deregistrationPolicy;
    }

    public final String snsTopic() {
        return this.snsTopic;
    }

    public final AssessmentReportsDestination defaultAssessmentReportsDestination() {
        return this.defaultAssessmentReportsDestination;
    }

    public final boolean hasDefaultProcessOwners() {
        return this.defaultProcessOwners != null && !(this.defaultProcessOwners instanceof SdkAutoConstructList);
    }

    public final List<Role> defaultProcessOwners() {
        return this.defaultProcessOwners;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final Boolean evidenceFinderEnabled() {
        return this.evidenceFinderEnabled;
    }

    public final DeregistrationPolicy deregistrationPolicy() {
        return this.deregistrationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAssessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultProcessOwners() ? this.defaultProcessOwners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidenceFinderEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.deregistrationPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettingsRequest)) {
            return false;
        }
        UpdateSettingsRequest other = (UpdateSettingsRequest)((Object)obj);
        return Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.defaultAssessmentReportsDestination(), other.defaultAssessmentReportsDestination()) && this.hasDefaultProcessOwners() == other.hasDefaultProcessOwners() && Objects.equals(this.defaultProcessOwners(), other.defaultProcessOwners()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.evidenceFinderEnabled(), other.evidenceFinderEnabled()) && Objects.equals(this.deregistrationPolicy(), other.deregistrationPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSettingsRequest").add("SnsTopic", (Object)this.snsTopic()).add("DefaultAssessmentReportsDestination", (Object)this.defaultAssessmentReportsDestination()).add("DefaultProcessOwners", this.hasDefaultProcessOwners() ? this.defaultProcessOwners() : null).add("KmsKey", (Object)this.kmsKey()).add("EvidenceFinderEnabled", (Object)this.evidenceFinderEnabled()).add("DeregistrationPolicy", (Object)this.deregistrationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "snsTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "defaultAssessmentReportsDestination": {
                return Optional.ofNullable(clazz.cast(this.defaultAssessmentReportsDestination()));
            }
            case "defaultProcessOwners": {
                return Optional.ofNullable(clazz.cast(this.defaultProcessOwners()));
            }
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "evidenceFinderEnabled": {
                return Optional.ofNullable(clazz.cast(this.evidenceFinderEnabled()));
            }
            case "deregistrationPolicy": {
                return Optional.ofNullable(clazz.cast(this.deregistrationPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSettingsRequest, T> g) {
        return obj -> g.apply((UpdateSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String snsTopic;
        private AssessmentReportsDestination defaultAssessmentReportsDestination;
        private List<Role> defaultProcessOwners = DefaultSdkAutoConstructList.getInstance();
        private String kmsKey;
        private Boolean evidenceFinderEnabled;
        private DeregistrationPolicy deregistrationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSettingsRequest model) {
            super(model);
            this.snsTopic(model.snsTopic);
            this.defaultAssessmentReportsDestination(model.defaultAssessmentReportsDestination);
            this.defaultProcessOwners(model.defaultProcessOwners);
            this.kmsKey(model.kmsKey);
            this.evidenceFinderEnabled(model.evidenceFinderEnabled);
            this.deregistrationPolicy(model.deregistrationPolicy);
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final AssessmentReportsDestination.Builder getDefaultAssessmentReportsDestination() {
            return this.defaultAssessmentReportsDestination != null ? this.defaultAssessmentReportsDestination.toBuilder() : null;
        }

        public final void setDefaultAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination != null ? defaultAssessmentReportsDestination.build() : null;
        }

        @Override
        public final Builder defaultAssessmentReportsDestination(AssessmentReportsDestination defaultAssessmentReportsDestination) {
            this.defaultAssessmentReportsDestination = defaultAssessmentReportsDestination;
            return this;
        }

        public final List<Role.Builder> getDefaultProcessOwners() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.defaultProcessOwners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultProcessOwners(Collection<Role.BuilderImpl> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copyFromBuilder(defaultProcessOwners);
        }

        @Override
        public final Builder defaultProcessOwners(Collection<Role> defaultProcessOwners) {
            this.defaultProcessOwners = RolesCopier.copy(defaultProcessOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Role ... defaultProcessOwners) {
            this.defaultProcessOwners(Arrays.asList(defaultProcessOwners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultProcessOwners(Consumer<Role.Builder> ... defaultProcessOwners) {
            this.defaultProcessOwners(Stream.of(defaultProcessOwners).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final Boolean getEvidenceFinderEnabled() {
            return this.evidenceFinderEnabled;
        }

        public final void setEvidenceFinderEnabled(Boolean evidenceFinderEnabled) {
            this.evidenceFinderEnabled = evidenceFinderEnabled;
        }

        @Override
        public final Builder evidenceFinderEnabled(Boolean evidenceFinderEnabled) {
            this.evidenceFinderEnabled = evidenceFinderEnabled;
            return this;
        }

        public final DeregistrationPolicy.Builder getDeregistrationPolicy() {
            return this.deregistrationPolicy != null ? this.deregistrationPolicy.toBuilder() : null;
        }

        public final void setDeregistrationPolicy(DeregistrationPolicy.BuilderImpl deregistrationPolicy) {
            this.deregistrationPolicy = deregistrationPolicy != null ? deregistrationPolicy.build() : null;
        }

        @Override
        public final Builder deregistrationPolicy(DeregistrationPolicy deregistrationPolicy) {
            this.deregistrationPolicy = deregistrationPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSettingsRequest build() {
            return new UpdateSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSettingsRequest> {
        public Builder snsTopic(String var1);

        public Builder defaultAssessmentReportsDestination(AssessmentReportsDestination var1);

        default public Builder defaultAssessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> defaultAssessmentReportsDestination) {
            return this.defaultAssessmentReportsDestination((AssessmentReportsDestination)((AssessmentReportsDestination.Builder)AssessmentReportsDestination.builder().applyMutation(defaultAssessmentReportsDestination)).build());
        }

        public Builder defaultProcessOwners(Collection<Role> var1);

        public Builder defaultProcessOwners(Role ... var1);

        public Builder defaultProcessOwners(Consumer<Role.Builder> ... var1);

        public Builder kmsKey(String var1);

        public Builder evidenceFinderEnabled(Boolean var1);

        public Builder deregistrationPolicy(DeregistrationPolicy var1);

        default public Builder deregistrationPolicy(Consumer<DeregistrationPolicy.Builder> deregistrationPolicy) {
            return this.deregistrationPolicy((DeregistrationPolicy)((DeregistrationPolicy.Builder)DeregistrationPolicy.builder().applyMutation(deregistrationPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

