/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestRunsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunsResponse;
import software.amazon.awssdk.services.apptest.model.TestRunSummary;

public class ListTestRunsIterable
implements SdkIterable<ListTestRunsResponse> {
    private final AppTestClient client;
    private final ListTestRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestRunsIterable(AppTestClient client, ListTestRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestRunsResponseFetcher();
    }

    public Iterator<ListTestRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestRunSummary> testRuns() {
        Function<ListTestRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testRuns() != null) {
                return response.testRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestRunsResponseFetcher
    implements SyncPageFetcher<ListTestRunsResponse> {
        private ListTestRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestRunsResponse nextPage(ListTestRunsResponse previousPage) {
            if (previousPage == null) {
                return ListTestRunsIterable.this.client.listTestRuns(ListTestRunsIterable.this.firstRequest);
            }
            return ListTestRunsIterable.this.client.listTestRuns((ListTestRunsRequest)((Object)ListTestRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

