/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestAsyncClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse;
import software.amazon.awssdk.services.apptest.model.TestSuiteSummary;

public class ListTestSuitesPublisher
implements SdkPublisher<ListTestSuitesResponse> {
    private final AppTestAsyncClient client;
    private final ListTestSuitesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestSuitesPublisher(AppTestAsyncClient client, ListTestSuitesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestSuitesPublisher(AppTestAsyncClient client, ListTestSuitesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestSuitesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestSuitesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestSuiteSummary> testSuites() {
        Function<ListTestSuitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testSuites() != null) {
                return response.testSuites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestSuitesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestSuitesResponseFetcher
    implements AsyncPageFetcher<ListTestSuitesResponse> {
        private ListTestSuitesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestSuitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestSuitesResponse> nextPage(ListTestSuitesResponse previousPage) {
            if (previousPage == null) {
                return ListTestSuitesPublisher.this.client.listTestSuites(ListTestSuitesPublisher.this.firstRequest);
            }
            return ListTestSuitesPublisher.this.client.listTestSuites((ListTestSuitesRequest)((Object)ListTestSuitesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

