/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTestRunStepRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, GetTestRunStepRequest> {
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunId").getter(GetTestRunStepRequest.getter(GetTestRunStepRequest::testRunId)).setter(GetTestRunStepRequest.setter(Builder::testRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("testRunId").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(GetTestRunStepRequest.getter(GetTestRunStepRequest::stepName)).setter(GetTestRunStepRequest.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("stepName").build()}).build();
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(GetTestRunStepRequest.getter(GetTestRunStepRequest::testCaseId)).setter(GetTestRunStepRequest.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testCaseId").build()}).build();
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(GetTestRunStepRequest.getter(GetTestRunStepRequest::testSuiteId)).setter(GetTestRunStepRequest.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testSuiteId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_ID_FIELD, STEP_NAME_FIELD, TEST_CASE_ID_FIELD, TEST_SUITE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTestRunStepRequest.memberNameToFieldInitializer();
    private final String testRunId;
    private final String stepName;
    private final String testCaseId;
    private final String testSuiteId;

    private GetTestRunStepRequest(BuilderImpl builder) {
        super(builder);
        this.testRunId = builder.testRunId;
        this.stepName = builder.stepName;
        this.testCaseId = builder.testCaseId;
        this.testSuiteId = builder.testSuiteId;
    }

    public final String testRunId() {
        return this.testRunId;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestRunStepRequest)) {
            return false;
        }
        GetTestRunStepRequest other = (GetTestRunStepRequest)((Object)obj);
        return Objects.equals(this.testRunId(), other.testRunId()) && Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.testSuiteId(), other.testSuiteId());
    }

    public final String toString() {
        return ToString.builder((String)"GetTestRunStepRequest").add("TestRunId", (Object)this.testRunId()).add("StepName", (Object)this.stepName()).add("TestCaseId", (Object)this.testCaseId()).add("TestSuiteId", (Object)this.testSuiteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testRunId": {
                return Optional.ofNullable(clazz.cast(this.testRunId()));
            }
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("testRunId", TEST_RUN_ID_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestRunStepRequest, T> g) {
        return obj -> g.apply((GetTestRunStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String testRunId;
        private String stepName;
        private String testCaseId;
        private String testSuiteId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestRunStepRequest model) {
            super(model);
            this.testRunId(model.testRunId);
            this.stepName(model.stepName);
            this.testCaseId(model.testCaseId);
            this.testSuiteId(model.testSuiteId);
        }

        public final String getTestRunId() {
            return this.testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTestRunStepRequest build() {
            return new GetTestRunStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTestRunStepRequest> {
        public Builder testRunId(String var1);

        public Builder stepName(String var1);

        public Builder testCaseId(String var1);

        public Builder testSuiteId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

