/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.Step;
import software.amazon.awssdk.services.apptest.model.StepListCopier;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.services.apptest.model.TestCases;
import software.amazon.awssdk.services.apptest.model.TestSuiteLatestVersion;
import software.amazon.awssdk.services.apptest.model.TestSuiteLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTestSuiteResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, GetTestSuiteResponse> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::testSuiteId)).setter(GetTestSuiteResponse.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::name)).setter(GetTestSuiteResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<TestSuiteLatestVersion> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersion").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::latestVersion)).setter(GetTestSuiteResponse.setter(Builder::latestVersion)).constructor(TestSuiteLatestVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testSuiteVersion").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::testSuiteVersion)).setter(GetTestSuiteResponse.setter(Builder::testSuiteVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::statusAsString)).setter(GetTestSuiteResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::statusReason)).setter(GetTestSuiteResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> TEST_SUITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteArn").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::testSuiteArn)).setter(GetTestSuiteResponse.setter(Builder::testSuiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::creationTime)).setter(GetTestSuiteResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::lastUpdateTime)).setter(GetTestSuiteResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::description)).setter(GetTestSuiteResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Step>> BEFORE_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("beforeSteps").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::beforeSteps)).setter(GetTestSuiteResponse.setter(Builder::beforeSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Step>> AFTER_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("afterSteps").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::afterSteps)).setter(GetTestSuiteResponse.setter(Builder::afterSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TestCases> TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testCases").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::testCases)).setter(GetTestSuiteResponse.setter(Builder::testCases)).constructor(TestCases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTestSuiteResponse.getter(GetTestSuiteResponse::tags)).setter(GetTestSuiteResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD, NAME_FIELD, LATEST_VERSION_FIELD, TEST_SUITE_VERSION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TEST_SUITE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, DESCRIPTION_FIELD, BEFORE_STEPS_FIELD, AFTER_STEPS_FIELD, TEST_CASES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTestSuiteResponse.memberNameToFieldInitializer();
    private final String testSuiteId;
    private final String name;
    private final TestSuiteLatestVersion latestVersion;
    private final Integer testSuiteVersion;
    private final String status;
    private final String statusReason;
    private final String testSuiteArn;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String description;
    private final List<Step> beforeSteps;
    private final List<Step> afterSteps;
    private final TestCases testCases;
    private final Map<String, String> tags;

    private GetTestSuiteResponse(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.name = builder.name;
        this.latestVersion = builder.latestVersion;
        this.testSuiteVersion = builder.testSuiteVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.testSuiteArn = builder.testSuiteArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.description = builder.description;
        this.beforeSteps = builder.beforeSteps;
        this.afterSteps = builder.afterSteps;
        this.testCases = builder.testCases;
        this.tags = builder.tags;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    public final String name() {
        return this.name;
    }

    public final TestSuiteLatestVersion latestVersion() {
        return this.latestVersion;
    }

    public final Integer testSuiteVersion() {
        return this.testSuiteVersion;
    }

    public final TestSuiteLifecycle status() {
        return TestSuiteLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String testSuiteArn() {
        return this.testSuiteArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasBeforeSteps() {
        return this.beforeSteps != null && !(this.beforeSteps instanceof SdkAutoConstructList);
    }

    public final List<Step> beforeSteps() {
        return this.beforeSteps;
    }

    public final boolean hasAfterSteps() {
        return this.afterSteps != null && !(this.afterSteps instanceof SdkAutoConstructList);
    }

    public final List<Step> afterSteps() {
        return this.afterSteps;
    }

    public final TestCases testCases() {
        return this.testCases;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBeforeSteps() ? this.beforeSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAfterSteps() ? this.afterSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.testCases());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestSuiteResponse)) {
            return false;
        }
        GetTestSuiteResponse other = (GetTestSuiteResponse)((Object)obj);
        return Objects.equals(this.testSuiteId(), other.testSuiteId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.testSuiteVersion(), other.testSuiteVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.testSuiteArn(), other.testSuiteArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.description(), other.description()) && this.hasBeforeSteps() == other.hasBeforeSteps() && Objects.equals(this.beforeSteps(), other.beforeSteps()) && this.hasAfterSteps() == other.hasAfterSteps() && Objects.equals(this.afterSteps(), other.afterSteps()) && Objects.equals(this.testCases(), other.testCases()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetTestSuiteResponse").add("TestSuiteId", (Object)this.testSuiteId()).add("Name", (Object)this.name()).add("LatestVersion", (Object)this.latestVersion()).add("TestSuiteVersion", (Object)this.testSuiteVersion()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("TestSuiteArn", (Object)this.testSuiteArn()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Description", (Object)this.description()).add("BeforeSteps", this.hasBeforeSteps() ? this.beforeSteps() : null).add("AfterSteps", this.hasAfterSteps() ? this.afterSteps() : null).add("TestCases", (Object)this.testCases()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "testSuiteVersion": {
                return Optional.ofNullable(clazz.cast(this.testSuiteVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "testSuiteArn": {
                return Optional.ofNullable(clazz.cast(this.testSuiteArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "beforeSteps": {
                return Optional.ofNullable(clazz.cast(this.beforeSteps()));
            }
            case "afterSteps": {
                return Optional.ofNullable(clazz.cast(this.afterSteps()));
            }
            case "testCases": {
                return Optional.ofNullable(clazz.cast(this.testCases()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        map.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("testSuiteArn", TEST_SUITE_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("beforeSteps", BEFORE_STEPS_FIELD);
        map.put("afterSteps", AFTER_STEPS_FIELD);
        map.put("testCases", TEST_CASES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestSuiteResponse, T> g) {
        return obj -> g.apply((GetTestSuiteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private String testSuiteId;
        private String name;
        private TestSuiteLatestVersion latestVersion;
        private Integer testSuiteVersion;
        private String status;
        private String statusReason;
        private String testSuiteArn;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String description;
        private List<Step> beforeSteps = DefaultSdkAutoConstructList.getInstance();
        private List<Step> afterSteps = DefaultSdkAutoConstructList.getInstance();
        private TestCases testCases;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestSuiteResponse model) {
            super(model);
            this.testSuiteId(model.testSuiteId);
            this.name(model.name);
            this.latestVersion(model.latestVersion);
            this.testSuiteVersion(model.testSuiteVersion);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.testSuiteArn(model.testSuiteArn);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.description(model.description);
            this.beforeSteps(model.beforeSteps);
            this.afterSteps(model.afterSteps);
            this.testCases(model.testCases);
            this.tags(model.tags);
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TestSuiteLatestVersion.Builder getLatestVersion() {
            return this.latestVersion != null ? this.latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(TestSuiteLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(TestSuiteLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return this.testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestSuiteLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getTestSuiteArn() {
            return this.testSuiteArn;
        }

        public final void setTestSuiteArn(String testSuiteArn) {
            this.testSuiteArn = testSuiteArn;
        }

        @Override
        public final Builder testSuiteArn(String testSuiteArn) {
            this.testSuiteArn = testSuiteArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getBeforeSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.beforeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeSteps(Collection<Step.BuilderImpl> beforeSteps) {
            this.beforeSteps = StepListCopier.copyFromBuilder(beforeSteps);
        }

        @Override
        public final Builder beforeSteps(Collection<Step> beforeSteps) {
            this.beforeSteps = StepListCopier.copy(beforeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Step ... beforeSteps) {
            this.beforeSteps(Arrays.asList(beforeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Consumer<Step.Builder> ... beforeSteps) {
            this.beforeSteps(Stream.of(beforeSteps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Step.Builder> getAfterSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.afterSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterSteps(Collection<Step.BuilderImpl> afterSteps) {
            this.afterSteps = StepListCopier.copyFromBuilder(afterSteps);
        }

        @Override
        public final Builder afterSteps(Collection<Step> afterSteps) {
            this.afterSteps = StepListCopier.copy(afterSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Step ... afterSteps) {
            this.afterSteps(Arrays.asList(afterSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Consumer<Step.Builder> ... afterSteps) {
            this.afterSteps(Stream.of(afterSteps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TestCases.Builder getTestCases() {
            return this.testCases != null ? this.testCases.toBuilder() : null;
        }

        public final void setTestCases(TestCases.BuilderImpl testCases) {
            this.testCases = testCases != null ? testCases.build() : null;
        }

        @Override
        public final Builder testCases(TestCases testCases) {
            this.testCases = testCases;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTestSuiteResponse build() {
            return new GetTestSuiteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTestSuiteResponse> {
        public Builder testSuiteId(String var1);

        public Builder name(String var1);

        public Builder latestVersion(TestSuiteLatestVersion var1);

        default public Builder latestVersion(Consumer<TestSuiteLatestVersion.Builder> latestVersion) {
            return this.latestVersion((TestSuiteLatestVersion)((TestSuiteLatestVersion.Builder)TestSuiteLatestVersion.builder().applyMutation(latestVersion)).build());
        }

        public Builder testSuiteVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(TestSuiteLifecycle var1);

        public Builder statusReason(String var1);

        public Builder testSuiteArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder description(String var1);

        public Builder beforeSteps(Collection<Step> var1);

        public Builder beforeSteps(Step ... var1);

        public Builder beforeSteps(Consumer<Step.Builder> ... var1);

        public Builder afterSteps(Collection<Step> var1);

        public Builder afterSteps(Step ... var1);

        public Builder afterSteps(Consumer<Step.Builder> ... var1);

        public Builder testCases(TestCases var1);

        default public Builder testCases(Consumer<TestCases.Builder> testCases) {
            return this.testCases((TestCases)((TestCases.Builder)TestCases.builder().applyMutation(testCases)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

