/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.BatchJobParametersCopier;
import software.amazon.awssdk.services.apptest.model.ExportDataSetNamesCopier;
import software.amazon.awssdk.services.apptest.model.MainframeActionProperties;
import software.amazon.awssdk.services.apptest.model.MainframeResourceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStepInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchStepInput> {
    private static final SdkField<MainframeResourceSummary> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(BatchStepInput.getter(BatchStepInput::resource)).setter(BatchStepInput.setter(Builder::resource)).constructor(MainframeResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> BATCH_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("batchJobName").getter(BatchStepInput.getter(BatchStepInput::batchJobName)).setter(BatchStepInput.setter(Builder::batchJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobName").build()}).build();
    private static final SdkField<Map<String, String>> BATCH_JOB_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("batchJobParameters").getter(BatchStepInput.getter(BatchStepInput::batchJobParameters)).setter(BatchStepInput.setter(Builder::batchJobParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPORT_DATA_SET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportDataSetNames").getter(BatchStepInput.getter(BatchStepInput::exportDataSetNames)).setter(BatchStepInput.setter(Builder::exportDataSetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataSetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MainframeActionProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("properties").getter(BatchStepInput.getter(BatchStepInput::properties)).setter(BatchStepInput.setter(Builder::properties)).constructor(MainframeActionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, BATCH_JOB_NAME_FIELD, BATCH_JOB_PARAMETERS_FIELD, EXPORT_DATA_SET_NAMES_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchStepInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MainframeResourceSummary resource;
    private final String batchJobName;
    private final Map<String, String> batchJobParameters;
    private final List<String> exportDataSetNames;
    private final MainframeActionProperties properties;

    private BatchStepInput(BuilderImpl builder) {
        this.resource = builder.resource;
        this.batchJobName = builder.batchJobName;
        this.batchJobParameters = builder.batchJobParameters;
        this.exportDataSetNames = builder.exportDataSetNames;
        this.properties = builder.properties;
    }

    public final MainframeResourceSummary resource() {
        return this.resource;
    }

    public final String batchJobName() {
        return this.batchJobName;
    }

    public final boolean hasBatchJobParameters() {
        return this.batchJobParameters != null && !(this.batchJobParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> batchJobParameters() {
        return this.batchJobParameters;
    }

    public final boolean hasExportDataSetNames() {
        return this.exportDataSetNames != null && !(this.exportDataSetNames instanceof SdkAutoConstructList);
    }

    public final List<String> exportDataSetNames() {
        return this.exportDataSetNames;
    }

    public final MainframeActionProperties properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchJobParameters() ? this.batchJobParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportDataSetNames() ? this.exportDataSetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStepInput)) {
            return false;
        }
        BatchStepInput other = (BatchStepInput)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.batchJobName(), other.batchJobName()) && this.hasBatchJobParameters() == other.hasBatchJobParameters() && Objects.equals(this.batchJobParameters(), other.batchJobParameters()) && this.hasExportDataSetNames() == other.hasExportDataSetNames() && Objects.equals(this.exportDataSetNames(), other.exportDataSetNames()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStepInput").add("Resource", (Object)this.resource()).add("BatchJobName", (Object)this.batchJobName()).add("BatchJobParameters", this.hasBatchJobParameters() ? this.batchJobParameters() : null).add("ExportDataSetNames", this.hasExportDataSetNames() ? this.exportDataSetNames() : null).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "batchJobName": {
                return Optional.ofNullable(clazz.cast(this.batchJobName()));
            }
            case "batchJobParameters": {
                return Optional.ofNullable(clazz.cast(this.batchJobParameters()));
            }
            case "exportDataSetNames": {
                return Optional.ofNullable(clazz.cast(this.exportDataSetNames()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resource", RESOURCE_FIELD);
        map.put("batchJobName", BATCH_JOB_NAME_FIELD);
        map.put("batchJobParameters", BATCH_JOB_PARAMETERS_FIELD);
        map.put("exportDataSetNames", EXPORT_DATA_SET_NAMES_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchStepInput, T> g) {
        return obj -> g.apply((BatchStepInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MainframeResourceSummary resource;
        private String batchJobName;
        private Map<String, String> batchJobParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<String> exportDataSetNames = DefaultSdkAutoConstructList.getInstance();
        private MainframeActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStepInput model) {
            this.resource(model.resource);
            this.batchJobName(model.batchJobName);
            this.batchJobParameters(model.batchJobParameters);
            this.exportDataSetNames(model.exportDataSetNames);
            this.properties(model.properties);
        }

        public final MainframeResourceSummary.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(MainframeResourceSummary.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(MainframeResourceSummary resource) {
            this.resource = resource;
            return this;
        }

        public final String getBatchJobName() {
            return this.batchJobName;
        }

        public final void setBatchJobName(String batchJobName) {
            this.batchJobName = batchJobName;
        }

        @Override
        public final Builder batchJobName(String batchJobName) {
            this.batchJobName = batchJobName;
            return this;
        }

        public final Map<String, String> getBatchJobParameters() {
            if (this.batchJobParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.batchJobParameters;
        }

        public final void setBatchJobParameters(Map<String, String> batchJobParameters) {
            this.batchJobParameters = BatchJobParametersCopier.copy(batchJobParameters);
        }

        @Override
        public final Builder batchJobParameters(Map<String, String> batchJobParameters) {
            this.batchJobParameters = BatchJobParametersCopier.copy(batchJobParameters);
            return this;
        }

        public final Collection<String> getExportDataSetNames() {
            if (this.exportDataSetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportDataSetNames;
        }

        public final void setExportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
        }

        @Override
        public final Builder exportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataSetNames(String ... exportDataSetNames) {
            this.exportDataSetNames(Arrays.asList(exportDataSetNames));
            return this;
        }

        public final MainframeActionProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(MainframeActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(MainframeActionProperties properties) {
            this.properties = properties;
            return this;
        }

        public BatchStepInput build() {
            return new BatchStepInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchStepInput> {
        public Builder resource(MainframeResourceSummary var1);

        default public Builder resource(Consumer<MainframeResourceSummary.Builder> resource) {
            return this.resource((MainframeResourceSummary)((MainframeResourceSummary.Builder)MainframeResourceSummary.builder().applyMutation(resource)).build());
        }

        public Builder batchJobName(String var1);

        public Builder batchJobParameters(Map<String, String> var1);

        public Builder exportDataSetNames(Collection<String> var1);

        public Builder exportDataSetNames(String ... var1);

        public Builder properties(MainframeActionProperties var1);

        default public Builder properties(Consumer<MainframeActionProperties.Builder> properties) {
            return this.properties((MainframeActionProperties)((MainframeActionProperties.Builder)MainframeActionProperties.builder().applyMutation(properties)).build());
        }
    }
}

