/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.services.apptest.model.TestRunIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestRunsRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, ListTestRunsRequest> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(ListTestRunsRequest.getter(ListTestRunsRequest::testSuiteId)).setter(ListTestRunsRequest.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testSuiteId").build()}).build();
    private static final SdkField<List<String>> TEST_RUN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testRunIds").getter(ListTestRunsRequest.getter(ListTestRunsRequest::testRunIds)).setter(ListTestRunsRequest.setter(Builder::testRunIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testrunIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestRunsRequest.getter(ListTestRunsRequest::nextToken)).setter(ListTestRunsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTestRunsRequest.getter(ListTestRunsRequest::maxResults)).setter(ListTestRunsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD, TEST_RUN_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTestRunsRequest.memberNameToFieldInitializer();
    private final String testSuiteId;
    private final List<String> testRunIds;
    private final String nextToken;
    private final Integer maxResults;

    private ListTestRunsRequest(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.testRunIds = builder.testRunIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    public final boolean hasTestRunIds() {
        return this.testRunIds != null && !(this.testRunIds instanceof SdkAutoConstructList);
    }

    public final List<String> testRunIds() {
        return this.testRunIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestRunIds() ? this.testRunIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRunsRequest)) {
            return false;
        }
        ListTestRunsRequest other = (ListTestRunsRequest)((Object)obj);
        return Objects.equals(this.testSuiteId(), other.testSuiteId()) && this.hasTestRunIds() == other.hasTestRunIds() && Objects.equals(this.testRunIds(), other.testRunIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestRunsRequest").add("TestSuiteId", (Object)this.testSuiteId()).add("TestRunIds", this.hasTestRunIds() ? this.testRunIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
            case "testRunIds": {
                return Optional.ofNullable(clazz.cast(this.testRunIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("testrunIds", TEST_RUN_IDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestRunsRequest, T> g) {
        return obj -> g.apply((ListTestRunsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String testSuiteId;
        private List<String> testRunIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRunsRequest model) {
            super(model);
            this.testSuiteId(model.testSuiteId);
            this.testRunIds(model.testRunIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Collection<String> getTestRunIds() {
            if (this.testRunIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.testRunIds;
        }

        public final void setTestRunIds(Collection<String> testRunIds) {
            this.testRunIds = TestRunIdListCopier.copy(testRunIds);
        }

        @Override
        public final Builder testRunIds(Collection<String> testRunIds) {
            this.testRunIds = TestRunIdListCopier.copy(testRunIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRunIds(String ... testRunIds) {
            this.testRunIds(Arrays.asList(testRunIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestRunsRequest build() {
            return new ListTestRunsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestRunsRequest> {
        public Builder testSuiteId(String var1);

        public Builder testRunIds(Collection<String> var1);

        public Builder testRunIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

