/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.DataSet;
import software.amazon.awssdk.services.apptest.model.DataSetListCopier;
import software.amazon.awssdk.services.apptest.model.DatabaseCDC;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileMetadata> {
    private static final SdkField<List<DataSet>> DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSets").getter(FileMetadata.getter(FileMetadata::dataSets)).setter(FileMetadata.setter(Builder::dataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DatabaseCDC> DATABASE_CDC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("databaseCDC").getter(FileMetadata.getter(FileMetadata::databaseCDC)).setter(FileMetadata.setter(Builder::databaseCDC)).constructor(DatabaseCDC::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseCDC").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD, DATABASE_CDC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DataSet> dataSets;
    private final DatabaseCDC databaseCDC;
    private final Type type;

    private FileMetadata(BuilderImpl builder) {
        this.dataSets = builder.dataSets;
        this.databaseCDC = builder.databaseCDC;
        this.type = builder.type;
    }

    public final boolean hasDataSets() {
        return this.dataSets != null && !(this.dataSets instanceof SdkAutoConstructList);
    }

    public final List<DataSet> dataSets() {
        return this.dataSets;
    }

    public final DatabaseCDC databaseCDC() {
        return this.databaseCDC;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSets() ? this.dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseCDC());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileMetadata)) {
            return false;
        }
        FileMetadata other = (FileMetadata)obj;
        return this.hasDataSets() == other.hasDataSets() && Objects.equals(this.dataSets(), other.dataSets()) && Objects.equals(this.databaseCDC(), other.databaseCDC());
    }

    public final String toString() {
        return ToString.builder((String)"FileMetadata").add("DataSets", this.hasDataSets() ? this.dataSets() : null).add("DatabaseCDC", (Object)this.databaseCDC()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSets": {
                return Optional.ofNullable(clazz.cast(this.dataSets()));
            }
            case "databaseCDC": {
                return Optional.ofNullable(clazz.cast(this.databaseCDC()));
            }
        }
        return Optional.empty();
    }

    public static FileMetadata fromDataSets(List<DataSet> dataSets) {
        return (FileMetadata)FileMetadata.builder().dataSets(dataSets).build();
    }

    public static FileMetadata fromDatabaseCDC(DatabaseCDC databaseCDC) {
        return (FileMetadata)FileMetadata.builder().databaseCDC(databaseCDC).build();
    }

    public static FileMetadata fromDatabaseCDC(Consumer<DatabaseCDC.Builder> databaseCDC) {
        DatabaseCDC.Builder builder = DatabaseCDC.builder();
        databaseCDC.accept(builder);
        return FileMetadata.fromDatabaseCDC((DatabaseCDC)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSets", DATA_SETS_FIELD);
        map.put("databaseCDC", DATABASE_CDC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileMetadata, T> g) {
        return obj -> g.apply((FileMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATA_SETS,
        DATABASE_CDC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSet> dataSets = DefaultSdkAutoConstructList.getInstance();
        private DatabaseCDC databaseCDC;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FileMetadata model) {
            this.dataSets(model.dataSets);
            this.databaseCDC(model.databaseCDC);
        }

        public final List<DataSet.Builder> getDataSets() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DataSet.BuilderImpl> dataSets) {
            List<DataSet> oldValue = this.dataSets;
            this.dataSets = DataSetListCopier.copyFromBuilder(dataSets);
            this.handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DataSet> dataSets) {
            List<DataSet> oldValue = this.dataSets;
            this.dataSets = DataSetListCopier.copy(dataSets);
            this.handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSet ... dataSets) {
            this.dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSet.Builder> ... dataSets) {
            this.dataSets(Stream.of(dataSets).map(c -> (DataSet)((DataSet.Builder)DataSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DatabaseCDC.Builder getDatabaseCDC() {
            return this.databaseCDC != null ? this.databaseCDC.toBuilder() : null;
        }

        public final void setDatabaseCDC(DatabaseCDC.BuilderImpl databaseCDC) {
            DatabaseCDC oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC != null ? databaseCDC.build() : null;
            this.handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
        }

        @Override
        public final Builder databaseCDC(DatabaseCDC databaseCDC) {
            DatabaseCDC oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC;
            this.handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
            return this;
        }

        public FileMetadata build() {
            return new FileMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileMetadata> {
        public Builder dataSets(Collection<DataSet> var1);

        public Builder dataSets(DataSet ... var1);

        public Builder dataSets(Consumer<DataSet.Builder> ... var1);

        public Builder databaseCDC(DatabaseCDC var1);

        default public Builder databaseCDC(Consumer<DatabaseCDC.Builder> databaseCDC) {
            return this.databaseCDC((DatabaseCDC)((DatabaseCDC.Builder)DatabaseCDC.builder().applyMutation(databaseCDC)).build());
        }
    }
}

