/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.PropertiesCopier;
import software.amazon.awssdk.services.apptest.model.Resource;
import software.amazon.awssdk.services.apptest.model.ResourceListCopier;
import software.amazon.awssdk.services.apptest.model.ServiceSettings;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.services.apptest.model.TestConfigurationLatestVersion;
import software.amazon.awssdk.services.apptest.model.TestConfigurationLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTestConfigurationResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, GetTestConfigurationResponse> {
    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testConfigurationId").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::testConfigurationId)).setter(GetTestConfigurationResponse.setter(Builder::testConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::name)).setter(GetTestConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TEST_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testConfigurationArn").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::testConfigurationArn)).setter(GetTestConfigurationResponse.setter(Builder::testConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationArn").build()}).build();
    private static final SdkField<TestConfigurationLatestVersion> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersion").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::latestVersion)).setter(GetTestConfigurationResponse.setter(Builder::latestVersion)).constructor(TestConfigurationLatestVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final SdkField<Integer> TEST_CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testConfigurationVersion").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::testConfigurationVersion)).setter(GetTestConfigurationResponse.setter(Builder::testConfigurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::statusAsString)).setter(GetTestConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::statusReason)).setter(GetTestConfigurationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::creationTime)).setter(GetTestConfigurationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::lastUpdateTime)).setter(GetTestConfigurationResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::description)).setter(GetTestConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::resources)).setter(GetTestConfigurationResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::properties)).setter(GetTestConfigurationResponse.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::tags)).setter(GetTestConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ServiceSettings> SERVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceSettings").getter(GetTestConfigurationResponse.getter(GetTestConfigurationResponse::serviceSettings)).setter(GetTestConfigurationResponse.setter(Builder::serviceSettings)).constructor(ServiceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CONFIGURATION_ID_FIELD, NAME_FIELD, TEST_CONFIGURATION_ARN_FIELD, LATEST_VERSION_FIELD, TEST_CONFIGURATION_VERSION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, DESCRIPTION_FIELD, RESOURCES_FIELD, PROPERTIES_FIELD, TAGS_FIELD, SERVICE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTestConfigurationResponse.memberNameToFieldInitializer();
    private final String testConfigurationId;
    private final String name;
    private final String testConfigurationArn;
    private final TestConfigurationLatestVersion latestVersion;
    private final Integer testConfigurationVersion;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String description;
    private final List<Resource> resources;
    private final Map<String, String> properties;
    private final Map<String, String> tags;
    private final ServiceSettings serviceSettings;

    private GetTestConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.testConfigurationId = builder.testConfigurationId;
        this.name = builder.name;
        this.testConfigurationArn = builder.testConfigurationArn;
        this.latestVersion = builder.latestVersion;
        this.testConfigurationVersion = builder.testConfigurationVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.description = builder.description;
        this.resources = builder.resources;
        this.properties = builder.properties;
        this.tags = builder.tags;
        this.serviceSettings = builder.serviceSettings;
    }

    public final String testConfigurationId() {
        return this.testConfigurationId;
    }

    public final String name() {
        return this.name;
    }

    public final String testConfigurationArn() {
        return this.testConfigurationArn;
    }

    public final TestConfigurationLatestVersion latestVersion() {
        return this.latestVersion;
    }

    public final Integer testConfigurationVersion() {
        return this.testConfigurationVersion;
    }

    public final TestConfigurationLifecycle status() {
        return TestConfigurationLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigurationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestConfigurationResponse)) {
            return false;
        }
        GetTestConfigurationResponse other = (GetTestConfigurationResponse)((Object)obj);
        return Objects.equals(this.testConfigurationId(), other.testConfigurationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.testConfigurationArn(), other.testConfigurationArn()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.testConfigurationVersion(), other.testConfigurationVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.description(), other.description()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.serviceSettings(), other.serviceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTestConfigurationResponse").add("TestConfigurationId", (Object)this.testConfigurationId()).add("Name", (Object)this.name()).add("TestConfigurationArn", (Object)this.testConfigurationArn()).add("LatestVersion", (Object)this.latestVersion()).add("TestConfigurationVersion", (Object)this.testConfigurationVersion()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Description", (Object)this.description()).add("Resources", this.hasResources() ? this.resources() : null).add("Properties", this.hasProperties() ? this.properties() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ServiceSettings", (Object)this.serviceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.testConfigurationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "testConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.testConfigurationArn()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "testConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.testConfigurationVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "serviceSettings": {
                return Optional.ofNullable(clazz.cast(this.serviceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testConfigurationId", TEST_CONFIGURATION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("testConfigurationArn", TEST_CONFIGURATION_ARN_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        map.put("testConfigurationVersion", TEST_CONFIGURATION_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("serviceSettings", SERVICE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestConfigurationResponse, T> g) {
        return obj -> g.apply((GetTestConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private String testConfigurationId;
        private String name;
        private String testConfigurationArn;
        private TestConfigurationLatestVersion latestVersion;
        private Integer testConfigurationVersion;
        private String status;
        private String statusReason;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String description;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ServiceSettings serviceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestConfigurationResponse model) {
            super(model);
            this.testConfigurationId(model.testConfigurationId);
            this.name(model.name);
            this.testConfigurationArn(model.testConfigurationArn);
            this.latestVersion(model.latestVersion);
            this.testConfigurationVersion(model.testConfigurationVersion);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.description(model.description);
            this.resources(model.resources);
            this.properties(model.properties);
            this.tags(model.tags);
            this.serviceSettings(model.serviceSettings);
        }

        public final String getTestConfigurationId() {
            return this.testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTestConfigurationArn() {
            return this.testConfigurationArn;
        }

        public final void setTestConfigurationArn(String testConfigurationArn) {
            this.testConfigurationArn = testConfigurationArn;
        }

        @Override
        public final Builder testConfigurationArn(String testConfigurationArn) {
            this.testConfigurationArn = testConfigurationArn;
            return this;
        }

        public final TestConfigurationLatestVersion.Builder getLatestVersion() {
            return this.latestVersion != null ? this.latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(TestConfigurationLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(TestConfigurationLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTestConfigurationVersion() {
            return this.testConfigurationVersion;
        }

        public final void setTestConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
        }

        @Override
        public final Builder testConfigurationVersion(Integer testConfigurationVersion) {
            this.testConfigurationVersion = testConfigurationVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestConfigurationLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = PropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = PropertiesCopier.copy(properties);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ServiceSettings.Builder getServiceSettings() {
            return this.serviceSettings != null ? this.serviceSettings.toBuilder() : null;
        }

        public final void setServiceSettings(ServiceSettings.BuilderImpl serviceSettings) {
            this.serviceSettings = serviceSettings != null ? serviceSettings.build() : null;
        }

        @Override
        public final Builder serviceSettings(ServiceSettings serviceSettings) {
            this.serviceSettings = serviceSettings;
            return this;
        }

        @Override
        public GetTestConfigurationResponse build() {
            return new GetTestConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTestConfigurationResponse> {
        public Builder testConfigurationId(String var1);

        public Builder name(String var1);

        public Builder testConfigurationArn(String var1);

        public Builder latestVersion(TestConfigurationLatestVersion var1);

        default public Builder latestVersion(Consumer<TestConfigurationLatestVersion.Builder> latestVersion) {
            return this.latestVersion((TestConfigurationLatestVersion)((TestConfigurationLatestVersion.Builder)TestConfigurationLatestVersion.builder().applyMutation(latestVersion)).build());
        }

        public Builder testConfigurationVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(TestConfigurationLifecycle var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder description(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder properties(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder serviceSettings(ServiceSettings var1);

        default public Builder serviceSettings(Consumer<ServiceSettings.Builder> serviceSettings) {
            return this.serviceSettings((ServiceSettings)((ServiceSettings.Builder)ServiceSettings.builder().applyMutation(serviceSettings)).build());
        }
    }
}

