/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestAsyncClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestRunsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunsResponse;
import software.amazon.awssdk.services.apptest.model.TestRunSummary;

public class ListTestRunsPublisher
implements SdkPublisher<ListTestRunsResponse> {
    private final AppTestAsyncClient client;
    private final ListTestRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestRunsPublisher(AppTestAsyncClient client, ListTestRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestRunsPublisher(AppTestAsyncClient client, ListTestRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestRunSummary> testRuns() {
        Function<ListTestRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testRuns() != null) {
                return response.testRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestRunsResponseFetcher
    implements AsyncPageFetcher<ListTestRunsResponse> {
        private ListTestRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestRunsResponse> nextPage(ListTestRunsResponse previousPage) {
            if (previousPage == null) {
                return ListTestRunsPublisher.this.client.listTestRuns(ListTestRunsPublisher.this.firstRequest);
            }
            return ListTestRunsPublisher.this.client.listTestRuns((ListTestRunsRequest)((Object)ListTestRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

