/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.BatchSummary;
import software.amazon.awssdk.services.apptest.model.TN3270Summary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MainframeActionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MainframeActionSummary> {
    private static final SdkField<BatchSummary> BATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batch").getter(MainframeActionSummary.getter(MainframeActionSummary::batch)).setter(MainframeActionSummary.setter(Builder::batch)).constructor(BatchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batch").build()}).build();
    private static final SdkField<TN3270Summary> TN3270_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tn3270").getter(MainframeActionSummary.getter(MainframeActionSummary::tn3270)).setter(MainframeActionSummary.setter(Builder::tn3270)).constructor(TN3270Summary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tn3270").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_FIELD, TN3270_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("batch", BATCH_FIELD);
            this.put("tn3270", TN3270_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BatchSummary batch;
    private final TN3270Summary tn3270;
    private final Type type;

    private MainframeActionSummary(BuilderImpl builder) {
        this.batch = builder.batch;
        this.tn3270 = builder.tn3270;
        this.type = builder.type;
    }

    public final BatchSummary batch() {
        return this.batch;
    }

    public final TN3270Summary tn3270() {
        return this.tn3270;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batch());
        hashCode = 31 * hashCode + Objects.hashCode(this.tn3270());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MainframeActionSummary)) {
            return false;
        }
        MainframeActionSummary other = (MainframeActionSummary)obj;
        return Objects.equals(this.batch(), other.batch()) && Objects.equals(this.tn3270(), other.tn3270());
    }

    public final String toString() {
        return ToString.builder((String)"MainframeActionSummary").add("Batch", (Object)this.batch()).add("Tn3270", (Object)this.tn3270()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batch": {
                return Optional.ofNullable(clazz.cast(this.batch()));
            }
            case "tn3270": {
                return Optional.ofNullable(clazz.cast(this.tn3270()));
            }
        }
        return Optional.empty();
    }

    public static MainframeActionSummary fromBatch(BatchSummary batch) {
        return (MainframeActionSummary)MainframeActionSummary.builder().batch(batch).build();
    }

    public static MainframeActionSummary fromBatch(Consumer<BatchSummary.Builder> batch) {
        BatchSummary.Builder builder = BatchSummary.builder();
        batch.accept(builder);
        return MainframeActionSummary.fromBatch((BatchSummary)builder.build());
    }

    public static MainframeActionSummary fromTn3270(TN3270Summary tn3270) {
        return (MainframeActionSummary)MainframeActionSummary.builder().tn3270(tn3270).build();
    }

    public static MainframeActionSummary fromTn3270(Consumer<TN3270Summary.Builder> tn3270) {
        TN3270Summary.Builder builder = TN3270Summary.builder();
        tn3270.accept(builder);
        return MainframeActionSummary.fromTn3270((TN3270Summary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MainframeActionSummary, T> g) {
        return obj -> g.apply((MainframeActionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BATCH,
        TN3270,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private BatchSummary batch;
        private TN3270Summary tn3270;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MainframeActionSummary model) {
            this.batch(model.batch);
            this.tn3270(model.tn3270);
        }

        public final BatchSummary.Builder getBatch() {
            return this.batch != null ? this.batch.toBuilder() : null;
        }

        public final void setBatch(BatchSummary.BuilderImpl batch) {
            BatchSummary oldValue = this.batch;
            this.batch = batch != null ? batch.build() : null;
            this.handleUnionValueChange(Type.BATCH, oldValue, this.batch);
        }

        @Override
        public final Builder batch(BatchSummary batch) {
            BatchSummary oldValue = this.batch;
            this.batch = batch;
            this.handleUnionValueChange(Type.BATCH, oldValue, this.batch);
            return this;
        }

        public final TN3270Summary.Builder getTn3270() {
            return this.tn3270 != null ? this.tn3270.toBuilder() : null;
        }

        public final void setTn3270(TN3270Summary.BuilderImpl tn3270) {
            TN3270Summary oldValue = this.tn3270;
            this.tn3270 = tn3270 != null ? tn3270.build() : null;
            this.handleUnionValueChange(Type.TN3270, oldValue, this.tn3270);
        }

        @Override
        public final Builder tn3270(TN3270Summary tn3270) {
            TN3270Summary oldValue = this.tn3270;
            this.tn3270 = tn3270;
            this.handleUnionValueChange(Type.TN3270, oldValue, this.tn3270);
            return this;
        }

        public MainframeActionSummary build() {
            return new MainframeActionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MainframeActionSummary> {
        public Builder batch(BatchSummary var1);

        default public Builder batch(Consumer<BatchSummary.Builder> batch) {
            return this.batch((BatchSummary)((BatchSummary.Builder)BatchSummary.builder().applyMutation(batch)).build());
        }

        public Builder tn3270(TN3270Summary var1);

        default public Builder tn3270(Consumer<TN3270Summary.Builder> tn3270) {
            return this.tn3270((TN3270Summary)((TN3270Summary.Builder)TN3270Summary.builder().applyMutation(tn3270)).build());
        }
    }
}

