/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestAsyncClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.TestCaseRunSummary;

public class ListTestRunTestCasesPublisher
implements SdkPublisher<ListTestRunTestCasesResponse> {
    private final AppTestAsyncClient client;
    private final ListTestRunTestCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestRunTestCasesPublisher(AppTestAsyncClient client, ListTestRunTestCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestRunTestCasesPublisher(AppTestAsyncClient client, ListTestRunTestCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestRunTestCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestRunTestCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestCaseRunSummary> testRunTestCases() {
        Function<ListTestRunTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testRunTestCases() != null) {
                return response.testRunTestCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestRunTestCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestRunTestCasesResponseFetcher
    implements AsyncPageFetcher<ListTestRunTestCasesResponse> {
        private ListTestRunTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRunTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestRunTestCasesResponse> nextPage(ListTestRunTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListTestRunTestCasesPublisher.this.client.listTestRunTestCases(ListTestRunTestCasesPublisher.this.firstRequest);
            }
            return ListTestRunTestCasesPublisher.this.client.listTestRunTestCases((ListTestRunTestCasesRequest)((Object)ListTestRunTestCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

