/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.M2ManagedRuntime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2ManagedApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2ManagedApplicationSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(M2ManagedApplicationSummary.getter(M2ManagedApplicationSummary::applicationId)).setter(M2ManagedApplicationSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(M2ManagedApplicationSummary.getter(M2ManagedApplicationSummary::runtimeAsString)).setter(M2ManagedApplicationSummary.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("listenerPort").getter(M2ManagedApplicationSummary.getter(M2ManagedApplicationSummary::listenerPort)).setter(M2ManagedApplicationSummary.setter(Builder::listenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, RUNTIME_FIELD, LISTENER_PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("runtime", RUNTIME_FIELD);
            this.put("listenerPort", LISTENER_PORT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String runtime;
    private final Integer listenerPort;

    private M2ManagedApplicationSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.runtime = builder.runtime;
        this.listenerPort = builder.listenerPort;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final M2ManagedRuntime runtime() {
        return M2ManagedRuntime.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final Integer listenerPort() {
        return this.listenerPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationSummary)) {
            return false;
        }
        M2ManagedApplicationSummary other = (M2ManagedApplicationSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && Objects.equals(this.listenerPort(), other.listenerPort());
    }

    public final String toString() {
        return ToString.builder((String)"M2ManagedApplicationSummary").add("ApplicationId", (Object)this.applicationId()).add("Runtime", (Object)this.runtimeAsString()).add("ListenerPort", (Object)this.listenerPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "listenerPort": {
                return Optional.ofNullable(clazz.cast(this.listenerPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationSummary, T> g) {
        return obj -> g.apply((M2ManagedApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String runtime;
        private Integer listenerPort;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationSummary model) {
            this.applicationId(model.applicationId);
            this.runtime(model.runtime);
            this.listenerPort(model.listenerPort);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(M2ManagedRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final Integer getListenerPort() {
            return this.listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public M2ManagedApplicationSummary build() {
            return new M2ManagedApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2ManagedApplicationSummary> {
        public Builder applicationId(String var1);

        public Builder runtime(String var1);

        public Builder runtime(M2ManagedRuntime var1);

        public Builder listenerPort(Integer var1);
    }
}

