/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.TestCaseSummary;
import software.amazon.awssdk.services.apptest.model.TestCaseSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestCasesResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, ListTestCasesResponse> {
    private static final SdkField<List<TestCaseSummary>> TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testCases").getter(ListTestCasesResponse.getter(ListTestCasesResponse::testCases)).setter(ListTestCasesResponse.setter(Builder::testCases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestCaseSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestCasesResponse.getter(ListTestCasesResponse::nextToken)).setter(ListTestCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("testCases", TEST_CASES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TestCaseSummary> testCases;
    private final String nextToken;

    private ListTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.testCases = builder.testCases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestCases() {
        return this.testCases != null && !(this.testCases instanceof SdkAutoConstructList);
    }

    public final List<TestCaseSummary> testCases() {
        return this.testCases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestCases() ? this.testCases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestCasesResponse)) {
            return false;
        }
        ListTestCasesResponse other = (ListTestCasesResponse)((Object)obj);
        return this.hasTestCases() == other.hasTestCases() && Objects.equals(this.testCases(), other.testCases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestCasesResponse").add("TestCases", this.hasTestCases() ? this.testCases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCases": {
                return Optional.ofNullable(clazz.cast(this.testCases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTestCasesResponse, T> g) {
        return obj -> g.apply((ListTestCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private List<TestCaseSummary> testCases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestCasesResponse model) {
            super(model);
            this.testCases(model.testCases);
            this.nextToken(model.nextToken);
        }

        public final List<TestCaseSummary.Builder> getTestCases() {
            List<TestCaseSummary.Builder> result = TestCaseSummaryListCopier.copyToBuilder(this.testCases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestCases(Collection<TestCaseSummary.BuilderImpl> testCases) {
            this.testCases = TestCaseSummaryListCopier.copyFromBuilder(testCases);
        }

        @Override
        public final Builder testCases(Collection<TestCaseSummary> testCases) {
            this.testCases = TestCaseSummaryListCopier.copy(testCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(TestCaseSummary ... testCases) {
            this.testCases(Arrays.asList(testCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(Consumer<TestCaseSummary.Builder> ... testCases) {
            this.testCases(Stream.of(testCases).map(c -> (TestCaseSummary)((TestCaseSummary.Builder)TestCaseSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestCasesResponse build() {
            return new ListTestCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestCasesResponse> {
        public Builder testCases(Collection<TestCaseSummary> var1);

        public Builder testCases(TestCaseSummary ... var1);

        public Builder testCases(Consumer<TestCaseSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

