/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.PropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudFormationStepOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateCloudFormationStepOutput> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackId").getter(CreateCloudFormationStepOutput.getter(CreateCloudFormationStepOutput::stackId)).setter(CreateCloudFormationStepOutput.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackId").build()}).build();
    private static final SdkField<Map<String, String>> EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("exports").getter(CreateCloudFormationStepOutput.getter(CreateCloudFormationStepOutput::exports)).setter(CreateCloudFormationStepOutput.setter(Builder::exports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exports").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, EXPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stackId", STACK_ID_FIELD);
            this.put("exports", EXPORTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final Map<String, String> exports;

    private CreateCloudFormationStepOutput(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.exports = builder.exports;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final boolean hasExports() {
        return this.exports != null && !(this.exports instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> exports() {
        return this.exports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExports() ? this.exports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationStepOutput)) {
            return false;
        }
        CreateCloudFormationStepOutput other = (CreateCloudFormationStepOutput)obj;
        return Objects.equals(this.stackId(), other.stackId()) && this.hasExports() == other.hasExports() && Objects.equals(this.exports(), other.exports());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudFormationStepOutput").add("StackId", (Object)this.stackId()).add("Exports", this.hasExports() ? this.exports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "exports": {
                return Optional.ofNullable(clazz.cast(this.exports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationStepOutput, T> g) {
        return obj -> g.apply((CreateCloudFormationStepOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private Map<String, String> exports = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationStepOutput model) {
            this.stackId(model.stackId);
            this.exports(model.exports);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Map<String, String> getExports() {
            if (this.exports instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.exports;
        }

        public final void setExports(Map<String, String> exports) {
            this.exports = PropertiesCopier.copy(exports);
        }

        @Override
        public final Builder exports(Map<String, String> exports) {
            this.exports = PropertiesCopier.copy(exports);
            return this;
        }

        public CreateCloudFormationStepOutput build() {
            return new CreateCloudFormationStepOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateCloudFormationStepOutput> {
        public Builder stackId(String var1);

        public Builder exports(Map<String, String> var1);
    }
}

