/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloudFormationActionType {
    CREATE("Create"),
    DELETE("Delete"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudFormationActionType> VALUE_MAP;
    private final String value;

    private CloudFormationActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudFormationActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudFormationActionType> knownValues() {
        EnumSet<CloudFormationActionType> knownValues = EnumSet.allOf(CloudFormationActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloudFormationActionType.class, CloudFormationActionType::toString);
    }
}

