/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTestRunRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, StartTestRunRequest> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(StartTestRunRequest.getter(StartTestRunRequest::testSuiteId)).setter(StartTestRunRequest.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()}).build();
    private static final SdkField<String> TEST_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testConfigurationId").getter(StartTestRunRequest.getter(StartTestRunRequest::testConfigurationId)).setter(StartTestRunRequest.setter(Builder::testConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigurationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartTestRunRequest.getter(StartTestRunRequest::clientToken)).setter(StartTestRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartTestRunRequest.getter(StartTestRunRequest::tags)).setter(StartTestRunRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD, TEST_CONFIGURATION_ID_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("testSuiteId", TEST_SUITE_ID_FIELD);
            this.put("testConfigurationId", TEST_CONFIGURATION_ID_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String testSuiteId;
    private final String testConfigurationId;
    private final String clientToken;
    private final Map<String, String> tags;

    private StartTestRunRequest(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.testConfigurationId = builder.testConfigurationId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    public final String testConfigurationId() {
        return this.testConfigurationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTestRunRequest)) {
            return false;
        }
        StartTestRunRequest other = (StartTestRunRequest)((Object)obj);
        return Objects.equals(this.testSuiteId(), other.testSuiteId()) && Objects.equals(this.testConfigurationId(), other.testConfigurationId()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartTestRunRequest").add("TestSuiteId", (Object)this.testSuiteId()).add("TestConfigurationId", (Object)this.testConfigurationId()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
            case "testConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.testConfigurationId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartTestRunRequest, T> g) {
        return obj -> g.apply((StartTestRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String testSuiteId;
        private String testConfigurationId;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTestRunRequest model) {
            super(model);
            this.testSuiteId(model.testSuiteId);
            this.testConfigurationId(model.testConfigurationId);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final String getTestConfigurationId() {
            return this.testConfigurationId;
        }

        public final void setTestConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
        }

        @Override
        public final Builder testConfigurationId(String testConfigurationId) {
            this.testConfigurationId = testConfigurationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTestRunRequest build() {
            return new StartTestRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTestRunRequest> {
        public Builder testSuiteId(String var1);

        public Builder testConfigurationId(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

