/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.StepRunStatus;
import software.amazon.awssdk.services.apptest.model.StepRunSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTestRunStepResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, GetTestRunStepResponse> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::stepName)).setter(GetTestRunStepResponse.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testRunId").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::testRunId)).setter(GetTestRunStepResponse.setter(Builder::testRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()}).build();
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::testCaseId)).setter(GetTestRunStepResponse.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()}).build();
    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testCaseVersion").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::testCaseVersion)).setter(GetTestRunStepResponse.setter(Builder::testCaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()}).build();
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::testSuiteId)).setter(GetTestRunStepResponse.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()}).build();
    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testSuiteVersion").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::testSuiteVersion)).setter(GetTestRunStepResponse.setter(Builder::testSuiteVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteVersion").build()}).build();
    private static final SdkField<Boolean> BEFORE_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("beforeStep").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::beforeStep)).setter(GetTestRunStepResponse.setter(Builder::beforeStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeStep").build()}).build();
    private static final SdkField<Boolean> AFTER_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("afterStep").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::afterStep)).setter(GetTestRunStepResponse.setter(Builder::afterStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterStep").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::statusAsString)).setter(GetTestRunStepResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::statusReason)).setter(GetTestRunStepResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> RUN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("runStartTime").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::runStartTime)).setter(GetTestRunStepResponse.setter(Builder::runStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStartTime").build()}).build();
    private static final SdkField<Instant> RUN_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("runEndTime").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::runEndTime)).setter(GetTestRunStepResponse.setter(Builder::runEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEndTime").build()}).build();
    private static final SdkField<StepRunSummary> STEP_RUN_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stepRunSummary").getter(GetTestRunStepResponse.getter(GetTestRunStepResponse::stepRunSummary)).setter(GetTestRunStepResponse.setter(Builder::stepRunSummary)).constructor(StepRunSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepRunSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD, TEST_RUN_ID_FIELD, TEST_CASE_ID_FIELD, TEST_CASE_VERSION_FIELD, TEST_SUITE_ID_FIELD, TEST_SUITE_VERSION_FIELD, BEFORE_STEP_FIELD, AFTER_STEP_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RUN_START_TIME_FIELD, RUN_END_TIME_FIELD, STEP_RUN_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stepName", STEP_NAME_FIELD);
            this.put("testRunId", TEST_RUN_ID_FIELD);
            this.put("testCaseId", TEST_CASE_ID_FIELD);
            this.put("testCaseVersion", TEST_CASE_VERSION_FIELD);
            this.put("testSuiteId", TEST_SUITE_ID_FIELD);
            this.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
            this.put("beforeStep", BEFORE_STEP_FIELD);
            this.put("afterStep", AFTER_STEP_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("runStartTime", RUN_START_TIME_FIELD);
            this.put("runEndTime", RUN_END_TIME_FIELD);
            this.put("stepRunSummary", STEP_RUN_SUMMARY_FIELD);
        }
    });
    private final String stepName;
    private final String testRunId;
    private final String testCaseId;
    private final Integer testCaseVersion;
    private final String testSuiteId;
    private final Integer testSuiteVersion;
    private final Boolean beforeStep;
    private final Boolean afterStep;
    private final String status;
    private final String statusReason;
    private final Instant runStartTime;
    private final Instant runEndTime;
    private final StepRunSummary stepRunSummary;

    private GetTestRunStepResponse(BuilderImpl builder) {
        super(builder);
        this.stepName = builder.stepName;
        this.testRunId = builder.testRunId;
        this.testCaseId = builder.testCaseId;
        this.testCaseVersion = builder.testCaseVersion;
        this.testSuiteId = builder.testSuiteId;
        this.testSuiteVersion = builder.testSuiteVersion;
        this.beforeStep = builder.beforeStep;
        this.afterStep = builder.afterStep;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.runStartTime = builder.runStartTime;
        this.runEndTime = builder.runEndTime;
        this.stepRunSummary = builder.stepRunSummary;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final String testRunId() {
        return this.testRunId;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final Integer testCaseVersion() {
        return this.testCaseVersion;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    public final Integer testSuiteVersion() {
        return this.testSuiteVersion;
    }

    public final Boolean beforeStep() {
        return this.beforeStep;
    }

    public final Boolean afterStep() {
        return this.afterStep;
    }

    public final StepRunStatus status() {
        return StepRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant runStartTime() {
        return this.runStartTime;
    }

    public final Instant runEndTime() {
        return this.runEndTime;
    }

    public final StepRunSummary stepRunSummary() {
        return this.stepRunSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.runStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepRunSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestRunStepResponse)) {
            return false;
        }
        GetTestRunStepResponse other = (GetTestRunStepResponse)((Object)obj);
        return Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.testRunId(), other.testRunId()) && Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.testCaseVersion(), other.testCaseVersion()) && Objects.equals(this.testSuiteId(), other.testSuiteId()) && Objects.equals(this.testSuiteVersion(), other.testSuiteVersion()) && Objects.equals(this.beforeStep(), other.beforeStep()) && Objects.equals(this.afterStep(), other.afterStep()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.runStartTime(), other.runStartTime()) && Objects.equals(this.runEndTime(), other.runEndTime()) && Objects.equals(this.stepRunSummary(), other.stepRunSummary());
    }

    public final String toString() {
        return ToString.builder((String)"GetTestRunStepResponse").add("StepName", (Object)this.stepName()).add("TestRunId", (Object)this.testRunId()).add("TestCaseId", (Object)this.testCaseId()).add("TestCaseVersion", (Object)this.testCaseVersion()).add("TestSuiteId", (Object)this.testSuiteId()).add("TestSuiteVersion", (Object)this.testSuiteVersion()).add("BeforeStep", (Object)this.beforeStep()).add("AfterStep", (Object)this.afterStep()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("RunStartTime", (Object)this.runStartTime()).add("RunEndTime", (Object)this.runEndTime()).add("StepRunSummary", (Object)this.stepRunSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "testRunId": {
                return Optional.ofNullable(clazz.cast(this.testRunId()));
            }
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "testCaseVersion": {
                return Optional.ofNullable(clazz.cast(this.testCaseVersion()));
            }
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
            case "testSuiteVersion": {
                return Optional.ofNullable(clazz.cast(this.testSuiteVersion()));
            }
            case "beforeStep": {
                return Optional.ofNullable(clazz.cast(this.beforeStep()));
            }
            case "afterStep": {
                return Optional.ofNullable(clazz.cast(this.afterStep()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "runStartTime": {
                return Optional.ofNullable(clazz.cast(this.runStartTime()));
            }
            case "runEndTime": {
                return Optional.ofNullable(clazz.cast(this.runEndTime()));
            }
            case "stepRunSummary": {
                return Optional.ofNullable(clazz.cast(this.stepRunSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTestRunStepResponse, T> g) {
        return obj -> g.apply((GetTestRunStepResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private String stepName;
        private String testRunId;
        private String testCaseId;
        private Integer testCaseVersion;
        private String testSuiteId;
        private Integer testSuiteVersion;
        private Boolean beforeStep;
        private Boolean afterStep;
        private String status;
        private String statusReason;
        private Instant runStartTime;
        private Instant runEndTime;
        private StepRunSummary stepRunSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestRunStepResponse model) {
            super(model);
            this.stepName(model.stepName);
            this.testRunId(model.testRunId);
            this.testCaseId(model.testCaseId);
            this.testCaseVersion(model.testCaseVersion);
            this.testSuiteId(model.testSuiteId);
            this.testSuiteVersion(model.testSuiteVersion);
            this.beforeStep(model.beforeStep);
            this.afterStep(model.afterStep);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.runStartTime(model.runStartTime);
            this.runEndTime(model.runEndTime);
            this.stepRunSummary(model.stepRunSummary);
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getTestRunId() {
            return this.testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return this.testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return this.testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        public final Boolean getBeforeStep() {
            return this.beforeStep;
        }

        public final void setBeforeStep(Boolean beforeStep) {
            this.beforeStep = beforeStep;
        }

        @Override
        public final Builder beforeStep(Boolean beforeStep) {
            this.beforeStep = beforeStep;
            return this;
        }

        public final Boolean getAfterStep() {
            return this.afterStep;
        }

        public final void setAfterStep(Boolean afterStep) {
            this.afterStep = afterStep;
        }

        @Override
        public final Builder afterStep(Boolean afterStep) {
            this.afterStep = afterStep;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getRunStartTime() {
            return this.runStartTime;
        }

        public final void setRunStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
        }

        @Override
        public final Builder runStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
            return this;
        }

        public final Instant getRunEndTime() {
            return this.runEndTime;
        }

        public final void setRunEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
        }

        @Override
        public final Builder runEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
            return this;
        }

        public final StepRunSummary.Builder getStepRunSummary() {
            return this.stepRunSummary != null ? this.stepRunSummary.toBuilder() : null;
        }

        public final void setStepRunSummary(StepRunSummary.BuilderImpl stepRunSummary) {
            this.stepRunSummary = stepRunSummary != null ? stepRunSummary.build() : null;
        }

        @Override
        public final Builder stepRunSummary(StepRunSummary stepRunSummary) {
            this.stepRunSummary = stepRunSummary;
            return this;
        }

        @Override
        public GetTestRunStepResponse build() {
            return new GetTestRunStepResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTestRunStepResponse> {
        public Builder stepName(String var1);

        public Builder testRunId(String var1);

        public Builder testCaseId(String var1);

        public Builder testCaseVersion(Integer var1);

        public Builder testSuiteId(String var1);

        public Builder testSuiteVersion(Integer var1);

        public Builder beforeStep(Boolean var1);

        public Builder afterStep(Boolean var1);

        public Builder status(String var1);

        public Builder status(StepRunStatus var1);

        public Builder statusReason(String var1);

        public Builder runStartTime(Instant var1);

        public Builder runEndTime(Instant var1);

        public Builder stepRunSummary(StepRunSummary var1);

        default public Builder stepRunSummary(Consumer<StepRunSummary.Builder> stepRunSummary) {
            return this.stepRunSummary((StepRunSummary)((StepRunSummary.Builder)StepRunSummary.builder().applyMutation(stepRunSummary)).build());
        }
    }
}

