/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.Step;
import software.amazon.awssdk.services.apptest.model.StepListCopier;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.services.apptest.model.TestCaseLatestVersion;
import software.amazon.awssdk.services.apptest.model.TestCaseLifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTestCaseResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, GetTestCaseResponse> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(GetTestCaseResponse.getter(GetTestCaseResponse::testCaseId)).setter(GetTestCaseResponse.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()}).build();
    private static final SdkField<String> TEST_CASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseArn").getter(GetTestCaseResponse.getter(GetTestCaseResponse::testCaseArn)).setter(GetTestCaseResponse.setter(Builder::testCaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTestCaseResponse.getter(GetTestCaseResponse::name)).setter(GetTestCaseResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTestCaseResponse.getter(GetTestCaseResponse::description)).setter(GetTestCaseResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TestCaseLatestVersion> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersion").getter(GetTestCaseResponse.getter(GetTestCaseResponse::latestVersion)).setter(GetTestCaseResponse.setter(Builder::latestVersion)).constructor(TestCaseLatestVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("testCaseVersion").getter(GetTestCaseResponse.getter(GetTestCaseResponse::testCaseVersion)).setter(GetTestCaseResponse.setter(Builder::testCaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTestCaseResponse.getter(GetTestCaseResponse::statusAsString)).setter(GetTestCaseResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetTestCaseResponse.getter(GetTestCaseResponse::statusReason)).setter(GetTestCaseResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetTestCaseResponse.getter(GetTestCaseResponse::creationTime)).setter(GetTestCaseResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(GetTestCaseResponse.getter(GetTestCaseResponse::lastUpdateTime)).setter(GetTestCaseResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(GetTestCaseResponse.getter(GetTestCaseResponse::steps)).setter(GetTestCaseResponse.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTestCaseResponse.getter(GetTestCaseResponse::tags)).setter(GetTestCaseResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD, TEST_CASE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LATEST_VERSION_FIELD, TEST_CASE_VERSION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STEPS_FIELD, TAGS_FIELD));
    private final String testCaseId;
    private final String testCaseArn;
    private final String name;
    private final String description;
    private final TestCaseLatestVersion latestVersion;
    private final Integer testCaseVersion;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final List<Step> steps;
    private final Map<String, String> tags;

    private GetTestCaseResponse(BuilderImpl builder) {
        super(builder);
        this.testCaseId = builder.testCaseId;
        this.testCaseArn = builder.testCaseArn;
        this.name = builder.name;
        this.description = builder.description;
        this.latestVersion = builder.latestVersion;
        this.testCaseVersion = builder.testCaseVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.steps = builder.steps;
        this.tags = builder.tags;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final String testCaseArn() {
        return this.testCaseArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TestCaseLatestVersion latestVersion() {
        return this.latestVersion;
    }

    public final Integer testCaseVersion() {
        return this.testCaseVersion;
    }

    public final TestCaseLifecycle status() {
        return TestCaseLifecycle.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<Step> steps() {
        return this.steps;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestCaseResponse)) {
            return false;
        }
        GetTestCaseResponse other = (GetTestCaseResponse)((Object)obj);
        return Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.testCaseArn(), other.testCaseArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.testCaseVersion(), other.testCaseVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetTestCaseResponse").add("TestCaseId", (Object)this.testCaseId()).add("TestCaseArn", (Object)this.testCaseArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LatestVersion", (Object)this.latestVersion()).add("TestCaseVersion", (Object)this.testCaseVersion()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Steps", this.hasSteps() ? this.steps() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "testCaseArn": {
                return Optional.ofNullable(clazz.cast(this.testCaseArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "testCaseVersion": {
                return Optional.ofNullable(clazz.cast(this.testCaseVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTestCaseResponse, T> g) {
        return obj -> g.apply((GetTestCaseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private String testCaseId;
        private String testCaseArn;
        private String name;
        private String description;
        private TestCaseLatestVersion latestVersion;
        private Integer testCaseVersion;
        private String status;
        private String statusReason;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestCaseResponse model) {
            super(model);
            this.testCaseId(model.testCaseId);
            this.testCaseArn(model.testCaseArn);
            this.name(model.name);
            this.description(model.description);
            this.latestVersion(model.latestVersion);
            this.testCaseVersion(model.testCaseVersion);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.steps(model.steps);
            this.tags(model.tags);
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getTestCaseArn() {
            return this.testCaseArn;
        }

        public final void setTestCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
        }

        @Override
        public final Builder testCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestCaseLatestVersion.Builder getLatestVersion() {
            return this.latestVersion != null ? this.latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(TestCaseLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(TestCaseLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return this.testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTestCaseResponse build() {
            return new GetTestCaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTestCaseResponse> {
        public Builder testCaseId(String var1);

        public Builder testCaseArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder latestVersion(TestCaseLatestVersion var1);

        default public Builder latestVersion(Consumer<TestCaseLatestVersion.Builder> latestVersion) {
            return this.latestVersion((TestCaseLatestVersion)((TestCaseLatestVersion.Builder)TestCaseLatestVersion.builder().applyMutation(latestVersion)).build());
        }

        public Builder testCaseVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(TestCaseLifecycle var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder steps(Collection<Step> var1);

        public Builder steps(Step ... var1);

        public Builder steps(Consumer<Step.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

