/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TestCaseRunStatus {
    SUCCESS("Success"),
    RUNNING("Running"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestCaseRunStatus> VALUE_MAP;
    private final String value;

    private TestCaseRunStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestCaseRunStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestCaseRunStatus> knownValues() {
        EnumSet<TestCaseRunStatus> knownValues = EnumSet.allOf(TestCaseRunStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TestCaseRunStatus.class, TestCaseRunStatus::toString);
    }
}

