/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.FieldLogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfig> {
    private static final SdkField<String> FIELD_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogConfig.getter(LogConfig::fieldLogLevelAsString)).setter(LogConfig.setter(Builder::fieldLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldLogLevel").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LogConfig.getter(LogConfig::cloudWatchLogsRoleArn)).setter(LogConfig.setter(Builder::cloudWatchLogsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LOG_LEVEL_FIELD, CLOUD_WATCH_LOGS_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldLogLevel;
    private final String cloudWatchLogsRoleArn;

    private LogConfig(BuilderImpl builder) {
        this.fieldLogLevel = builder.fieldLogLevel;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
    }

    public FieldLogLevel fieldLogLevel() {
        return FieldLogLevel.fromValue(this.fieldLogLevel);
    }

    public String fieldLogLevelAsString() {
        return this.fieldLogLevel;
    }

    public String cloudWatchLogsRoleArn() {
        return this.cloudWatchLogsRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfig)) {
            return false;
        }
        LogConfig other = (LogConfig)obj;
        return Objects.equals(this.fieldLogLevelAsString(), other.fieldLogLevelAsString()) && Objects.equals(this.cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"LogConfig").add("FieldLogLevel", (Object)this.fieldLogLevelAsString()).add("CloudWatchLogsRoleArn", (Object)this.cloudWatchLogsRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldLogLevel": {
                return Optional.ofNullable(clazz.cast(this.fieldLogLevelAsString()));
            }
            case "cloudWatchLogsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfig, T> g) {
        return obj -> g.apply((LogConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldLogLevel;
        private String cloudWatchLogsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfig model) {
            this.fieldLogLevel(model.fieldLogLevel);
            this.cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
        }

        public final String getFieldLogLevelAsString() {
            return this.fieldLogLevel;
        }

        @Override
        public final Builder fieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
            return this;
        }

        @Override
        public final Builder fieldLogLevel(FieldLogLevel fieldLogLevel) {
            this.fieldLogLevel(fieldLogLevel == null ? null : fieldLogLevel.toString());
            return this;
        }

        public final void setFieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
        }

        public final String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public LogConfig build() {
            return new LogConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfig> {
        public Builder fieldLogLevel(String var1);

        public Builder fieldLogLevel(FieldLogLevel var1);

        public Builder cloudWatchLogsRoleArn(String var1);
    }
}

