/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsIamConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsIamConfig> {
    private static final SdkField<String> SIGNING_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamConfig.getter(AwsIamConfig::signingRegion)).setter(AwsIamConfig.setter(Builder::signingRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingRegion").build()}).build();
    private static final SdkField<String> SIGNING_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamConfig.getter(AwsIamConfig::signingServiceName)).setter(AwsIamConfig.setter(Builder::signingServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_REGION_FIELD, SIGNING_SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String signingRegion;
    private final String signingServiceName;

    private AwsIamConfig(BuilderImpl builder) {
        this.signingRegion = builder.signingRegion;
        this.signingServiceName = builder.signingServiceName;
    }

    public String signingRegion() {
        return this.signingRegion;
    }

    public String signingServiceName() {
        return this.signingServiceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingServiceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamConfig)) {
            return false;
        }
        AwsIamConfig other = (AwsIamConfig)obj;
        return Objects.equals(this.signingRegion(), other.signingRegion()) && Objects.equals(this.signingServiceName(), other.signingServiceName());
    }

    public String toString() {
        return ToString.builder((String)"AwsIamConfig").add("SigningRegion", (Object)this.signingRegion()).add("SigningServiceName", (Object)this.signingServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signingRegion": {
                return Optional.ofNullable(clazz.cast(this.signingRegion()));
            }
            case "signingServiceName": {
                return Optional.ofNullable(clazz.cast(this.signingServiceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamConfig, T> g) {
        return obj -> g.apply((AwsIamConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String signingRegion;
        private String signingServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamConfig model) {
            this.signingRegion(model.signingRegion);
            this.signingServiceName(model.signingServiceName);
        }

        public final String getSigningRegion() {
            return this.signingRegion;
        }

        @Override
        public final Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public final void setSigningRegion(String signingRegion) {
            this.signingRegion = signingRegion;
        }

        public final String getSigningServiceName() {
            return this.signingServiceName;
        }

        @Override
        public final Builder signingServiceName(String signingServiceName) {
            this.signingServiceName = signingServiceName;
            return this;
        }

        public final void setSigningServiceName(String signingServiceName) {
            this.signingServiceName = signingServiceName;
        }

        public AwsIamConfig build() {
            return new AwsIamConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsIamConfig> {
        public Builder signingRegion(String var1);

        public Builder signingServiceName(String var1);
    }
}

