/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenIDConnectConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenIDConnectConfig> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OpenIDConnectConfig.getter(OpenIDConnectConfig::issuer)).setter(OpenIDConnectConfig.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OpenIDConnectConfig.getter(OpenIDConnectConfig::clientId)).setter(OpenIDConnectConfig.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<Long> IAT_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(OpenIDConnectConfig.getter(OpenIDConnectConfig::iatTTL)).setter(OpenIDConnectConfig.setter(Builder::iatTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iatTTL").build()}).build();
    private static final SdkField<Long> AUTH_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(OpenIDConnectConfig.getter(OpenIDConnectConfig::authTTL)).setter(OpenIDConnectConfig.setter(Builder::authTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authTTL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, CLIENT_ID_FIELD, IAT_TTL_FIELD, AUTH_TTL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String issuer;
    private final String clientId;
    private final Long iatTTL;
    private final Long authTTL;

    private OpenIDConnectConfig(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.clientId = builder.clientId;
        this.iatTTL = builder.iatTTL;
        this.authTTL = builder.authTTL;
    }

    public String issuer() {
        return this.issuer;
    }

    public String clientId() {
        return this.clientId;
    }

    public Long iatTTL() {
        return this.iatTTL;
    }

    public Long authTTL() {
        return this.authTTL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iatTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTTL());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIDConnectConfig)) {
            return false;
        }
        OpenIDConnectConfig other = (OpenIDConnectConfig)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.iatTTL(), other.iatTTL()) && Objects.equals(this.authTTL(), other.authTTL());
    }

    public String toString() {
        return ToString.builder((String)"OpenIDConnectConfig").add("Issuer", (Object)this.issuer()).add("ClientId", (Object)this.clientId()).add("IatTTL", (Object)this.iatTTL()).add("AuthTTL", (Object)this.authTTL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "iatTTL": {
                return Optional.ofNullable(clazz.cast(this.iatTTL()));
            }
            case "authTTL": {
                return Optional.ofNullable(clazz.cast(this.authTTL()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenIDConnectConfig, T> g) {
        return obj -> g.apply((OpenIDConnectConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private String clientId;
        private Long iatTTL;
        private Long authTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIDConnectConfig model) {
            this.issuer(model.issuer);
            this.clientId(model.clientId);
            this.iatTTL(model.iatTTL);
            this.authTTL(model.authTTL);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Long getIatTTL() {
            return this.iatTTL;
        }

        @Override
        public final Builder iatTTL(Long iatTTL) {
            this.iatTTL = iatTTL;
            return this;
        }

        public final void setIatTTL(Long iatTTL) {
            this.iatTTL = iatTTL;
        }

        public final Long getAuthTTL() {
            return this.authTTL;
        }

        @Override
        public final Builder authTTL(Long authTTL) {
            this.authTTL = authTTL;
            return this;
        }

        public final void setAuthTTL(Long authTTL) {
            this.authTTL = authTTL;
        }

        public OpenIDConnectConfig build() {
            return new OpenIDConnectConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenIDConnectConfig> {
        public Builder issuer(String var1);

        public Builder clientId(String var1);

        public Builder iatTTL(Long var1);

        public Builder authTTL(Long var1);
    }
}

