/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiKeyValidityOutOfBoundsException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQlSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversByFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAppSyncAsyncClient
implements AppSyncAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAppSyncAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppSyncAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "appsync";
    }

    @Override
    public CompletableFuture<CreateApiKeyResponse> createApiKey(CreateApiKeyRequest createApiKeyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApiKeyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApiKey").withMarshaller((Marshaller)new CreateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApiKeyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSource").withMarshaller((Marshaller)new CreateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFunction").withMarshaller((Marshaller)new CreateFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFunctionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGraphqlApiResponse> createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGraphqlApiResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGraphqlApi").withMarshaller((Marshaller)new CreateGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGraphqlApiRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateResolverResponse> createResolver(CreateResolverRequest createResolverRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResolverResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResolver").withMarshaller((Marshaller)new CreateResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResolverRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTypeResponse> createType(CreateTypeRequest createTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateType").withMarshaller((Marshaller)new CreateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTypeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApiKeyResponse> deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApiKeyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApiKey").withMarshaller((Marshaller)new DeleteApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApiKeyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataSourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataSource").withMarshaller((Marshaller)new DeleteDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFunction").withMarshaller((Marshaller)new DeleteFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFunctionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteGraphqlApiResponse> deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGraphqlApiResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGraphqlApi").withMarshaller((Marshaller)new DeleteGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGraphqlApiRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResolverResponse> deleteResolver(DeleteResolverRequest deleteResolverRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResolverResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResolver").withMarshaller((Marshaller)new DeleteResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResolverRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTypeResponse> deleteType(DeleteTypeRequest deleteTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteType").withMarshaller((Marshaller)new DeleteTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTypeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataSourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataSource").withMarshaller((Marshaller)new GetDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFunction").withMarshaller((Marshaller)new GetFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFunctionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetGraphqlApiResponse> getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGraphqlApiResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGraphqlApi").withMarshaller((Marshaller)new GetGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGraphqlApiRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIntrospectionSchemaResponse> getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIntrospectionSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIntrospectionSchema").withMarshaller((Marshaller)new GetIntrospectionSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIntrospectionSchemaRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResolverResponse> getResolver(GetResolverRequest getResolverRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResolverResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResolver").withMarshaller((Marshaller)new GetResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResolverRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSchemaCreationStatusResponse> getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSchemaCreationStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSchemaCreationStatus").withMarshaller((Marshaller)new GetSchemaCreationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSchemaCreationStatusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTypeResponse> getType(GetTypeRequest getTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetType").withMarshaller((Marshaller)new GetTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTypeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApiKeysResponse> listApiKeys(ListApiKeysRequest listApiKeysRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApiKeysResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApiKeys").withMarshaller((Marshaller)new ListApiKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApiKeysRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourcesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSources").withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourcesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFunctionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFunctions").withMarshaller((Marshaller)new ListFunctionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFunctionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGraphqlApisResponse> listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGraphqlApisResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGraphqlApis").withMarshaller((Marshaller)new ListGraphqlApisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGraphqlApisRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResolversResponse> listResolvers(ListResolversRequest listResolversRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResolversResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResolvers").withMarshaller((Marshaller)new ListResolversRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResolversRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResolversByFunctionResponse> listResolversByFunction(ListResolversByFunctionRequest listResolversByFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResolversByFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResolversByFunction").withMarshaller((Marshaller)new ListResolversByFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResolversByFunctionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTypesResponse> listTypes(ListTypesRequest listTypesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypes").withMarshaller((Marshaller)new ListTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTypesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSchemaCreationResponse> startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSchemaCreationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSchemaCreation").withMarshaller((Marshaller)new StartSchemaCreationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSchemaCreationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApiKeyResponse> updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApiKeyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApiKey").withMarshaller((Marshaller)new UpdateApiKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApiKeyRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataSourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest updateFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFunctionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFunction").withMarshaller((Marshaller)new UpdateFunctionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFunctionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGraphqlApiResponse> updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGraphqlApiResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGraphqlApi").withMarshaller((Marshaller)new UpdateGraphqlApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGraphqlApiRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateResolverResponse> updateResolver(UpdateResolverRequest updateResolverRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResolverResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResolver").withMarshaller((Marshaller)new UpdateResolverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResolverRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTypeResponse> updateType(UpdateTypeRequest updateTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateType").withMarshaller((Marshaller)new UpdateTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTypeRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppSyncException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GraphQLSchemaException").exceptionBuilderSupplier(GraphQlSchemaException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException").exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException").exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApiLimitExceededException").exceptionBuilderSupplier(ApiLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

