/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.LambdaConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Integration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Integration> {
    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceName").getter(Integration.getter(Integration::dataSourceName)).setter(Integration.setter(Builder::dataSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()}).build();
    private static final SdkField<LambdaConfig> LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaConfig").getter(Integration.getter(Integration::lambdaConfig)).setter(Integration.setter(Builder::lambdaConfig)).constructor(LambdaConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_NAME_FIELD, LAMBDA_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Integration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSourceName;
    private final LambdaConfig lambdaConfig;

    private Integration(BuilderImpl builder) {
        this.dataSourceName = builder.dataSourceName;
        this.lambdaConfig = builder.lambdaConfig;
    }

    public final String dataSourceName() {
        return this.dataSourceName;
    }

    public final LambdaConfig lambdaConfig() {
        return this.lambdaConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)obj;
        return Objects.equals(this.dataSourceName(), other.dataSourceName()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Integration").add("DataSourceName", (Object)this.dataSourceName()).add("LambdaConfig", (Object)this.lambdaConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceName": {
                return Optional.ofNullable(clazz.cast(this.dataSourceName()));
            }
            case "lambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSourceName", DATA_SOURCE_NAME_FIELD);
        map.put("lambdaConfig", LAMBDA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Integration, T> g) {
        return obj -> g.apply((Integration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceName;
        private LambdaConfig lambdaConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Integration model) {
            this.dataSourceName(model.dataSourceName);
            this.lambdaConfig(model.lambdaConfig);
        }

        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final LambdaConfig.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public Integration build() {
            return new Integration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Integration> {
        public Builder dataSourceName(String var1);

        public Builder lambdaConfig(LambdaConfig var1);

        default public Builder lambdaConfig(Consumer<LambdaConfig.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaConfig)((LambdaConfig.Builder)LambdaConfig.builder().applyMutation(lambdaConfig)).build());
        }
    }
}

