/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appsync.model.EventConfig;
import software.amazon.awssdk.services.appsync.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.appsync.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Api
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Api> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(Api.getter(Api::apiId)).setter(Api.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Api.getter(Api::name)).setter(Api.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerContact").getter(Api.getter(Api::ownerContact)).setter(Api.setter(Builder::ownerContact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Api.getter(Api::tags)).setter(Api.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> DNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("dns").getter(Api.getter(Api::dns)).setter(Api.setter(Builder::dns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> API_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiArn").getter(Api.getter(Api::apiArn)).setter(Api.setter(Builder::apiArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiArn").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Api.getter(Api::created)).setter(Api.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("xrayEnabled").getter(Api.getter(Api::xrayEnabled)).setter(Api.setter(Builder::xrayEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()}).build();
    private static final SdkField<String> WAF_WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("wafWebAclArn").getter(Api.getter(Api::wafWebAclArn)).setter(Api.setter(Builder::wafWebAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wafWebAclArn").build()}).build();
    private static final SdkField<EventConfig> EVENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventConfig").getter(Api.getter(Api::eventConfig)).setter(Api.setter(Builder::eventConfig)).constructor(EventConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD, OWNER_CONTACT_FIELD, TAGS_FIELD, DNS_FIELD, API_ARN_FIELD, CREATED_FIELD, XRAY_ENABLED_FIELD, WAF_WEB_ACL_ARN_FIELD, EVENT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiId;
    private final String name;
    private final String ownerContact;
    private final Map<String, String> tags;
    private final Map<String, String> dns;
    private final String apiArn;
    private final Instant created;
    private final Boolean xrayEnabled;
    private final String wafWebAclArn;
    private final EventConfig eventConfig;

    private Api(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.ownerContact = builder.ownerContact;
        this.tags = builder.tags;
        this.dns = builder.dns;
        this.apiArn = builder.apiArn;
        this.created = builder.created;
        this.xrayEnabled = builder.xrayEnabled;
        this.wafWebAclArn = builder.wafWebAclArn;
        this.eventConfig = builder.eventConfig;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerContact() {
        return this.ownerContact;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasDns() {
        return this.dns != null && !(this.dns instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dns() {
        return this.dns;
    }

    public final String apiArn() {
        return this.apiArn;
    }

    public final Instant created() {
        return this.created;
    }

    public final Boolean xrayEnabled() {
        return this.xrayEnabled;
    }

    public final String wafWebAclArn() {
        return this.wafWebAclArn;
    }

    public final EventConfig eventConfig() {
        return this.eventConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDns() ? this.dns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.wafWebAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Api)) {
            return false;
        }
        Api other = (Api)obj;
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerContact(), other.ownerContact()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasDns() == other.hasDns() && Objects.equals(this.dns(), other.dns()) && Objects.equals(this.apiArn(), other.apiArn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.xrayEnabled(), other.xrayEnabled()) && Objects.equals(this.wafWebAclArn(), other.wafWebAclArn()) && Objects.equals(this.eventConfig(), other.eventConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Api").add("ApiId", (Object)this.apiId()).add("Name", (Object)this.name()).add("OwnerContact", (Object)this.ownerContact()).add("Tags", this.hasTags() ? this.tags() : null).add("Dns", this.hasDns() ? this.dns() : null).add("ApiArn", (Object)this.apiArn()).add("Created", (Object)this.created()).add("XrayEnabled", (Object)this.xrayEnabled()).add("WafWebAclArn", (Object)this.wafWebAclArn()).add("EventConfig", (Object)this.eventConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ownerContact": {
                return Optional.ofNullable(clazz.cast(this.ownerContact()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "dns": {
                return Optional.ofNullable(clazz.cast(this.dns()));
            }
            case "apiArn": {
                return Optional.ofNullable(clazz.cast(this.apiArn()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "xrayEnabled": {
                return Optional.ofNullable(clazz.cast(this.xrayEnabled()));
            }
            case "wafWebAclArn": {
                return Optional.ofNullable(clazz.cast(this.wafWebAclArn()));
            }
            case "eventConfig": {
                return Optional.ofNullable(clazz.cast(this.eventConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Api, T> g) {
        return obj -> g.apply((Api)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String name;
        private String ownerContact;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> dns = DefaultSdkAutoConstructMap.getInstance();
        private String apiArn;
        private Instant created;
        private Boolean xrayEnabled;
        private String wafWebAclArn;
        private EventConfig eventConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Api model) {
            this.apiId(model.apiId);
            this.name(model.name);
            this.ownerContact(model.ownerContact);
            this.tags(model.tags);
            this.dns(model.dns);
            this.apiArn(model.apiArn);
            this.created(model.created);
            this.xrayEnabled(model.xrayEnabled);
            this.wafWebAclArn(model.wafWebAclArn);
            this.eventConfig(model.eventConfig);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerContact() {
            return this.ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getDns() {
            if (this.dns instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dns;
        }

        public final void setDns(Map<String, String> dns) {
            this.dns = MapOfStringToStringCopier.copy(dns);
        }

        @Override
        public final Builder dns(Map<String, String> dns) {
            this.dns = MapOfStringToStringCopier.copy(dns);
            return this;
        }

        public final String getApiArn() {
            return this.apiArn;
        }

        public final void setApiArn(String apiArn) {
            this.apiArn = apiArn;
        }

        @Override
        public final Builder apiArn(String apiArn) {
            this.apiArn = apiArn;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Boolean getXrayEnabled() {
            return this.xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final String getWafWebAclArn() {
            return this.wafWebAclArn;
        }

        public final void setWafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
        }

        @Override
        public final Builder wafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
            return this;
        }

        public final EventConfig.Builder getEventConfig() {
            return this.eventConfig != null ? this.eventConfig.toBuilder() : null;
        }

        public final void setEventConfig(EventConfig.BuilderImpl eventConfig) {
            this.eventConfig = eventConfig != null ? eventConfig.build() : null;
        }

        @Override
        public final Builder eventConfig(EventConfig eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        public Api build() {
            return new Api(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Api> {
        public Builder apiId(String var1);

        public Builder name(String var1);

        public Builder ownerContact(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder dns(Map<String, String> var1);

        public Builder apiArn(String var1);

        public Builder created(Instant var1);

        public Builder xrayEnabled(Boolean var1);

        public Builder wafWebAclArn(String var1);

        public Builder eventConfig(EventConfig var1);

        default public Builder eventConfig(Consumer<EventConfig.Builder> eventConfig) {
            return this.eventConfig((EventConfig)((EventConfig.Builder)EventConfig.builder().applyMutation(eventConfig)).build());
        }
    }
}

